/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.tree.TreePath;
import photoorganizer.Controller;
import photoorganizer.Resources;
import photoorganizer.formats.AbstractFormat;
import photoorganizer.formats.AbstractInfo;
import photoorganizer.formats.BasicJpeg;
import photoorganizer.formats.FileNameFormat;
import photoorganizer.formats.MP3;
import photoorganizer.formats.MediaFormatFactory;
import photoorganizer.formats.Thumbnail;
import photoorganizer.renderer.AlbumPane;
import photoorganizer.renderer.AlbumSelectionDialog;
import photoorganizer.renderer.FastMenu;
import photoorganizer.renderer.PhotoCollectionPanel;
import photoorganizer.renderer.PhotoImagePanel;
import photoorganizer.renderer.PropertiesPanel;
import photoorganizer.renderer.RenameOptionsTab;
import photoorganizer.renderer.ThumbnailsOptionsTab;
import rogatkin.Serializer;

public class ThumbnailsPanel
extends JPanel {
    public static final int THUMB_SIZE_X = 162;
    public static final int THUMB_SIZE_Y = 142;
    static final int THUMBS_IN_ROW = 5;
    private int labelTextHeight = 16;
    Dimension preferredsize = new Dimension(0, 160);
    Controller controller;
    private Thumbnail current_thumb;
    protected PhotoCollectionPanel collectionpanel;
    protected AlbumPane albumpanel;
    protected PhotoImagePanel imagepanel;
    protected int time;
    protected long length;
    private int v;
    private int h;
    private int sx;
    private int sy;
    private Border reg_border;
    private Border selected_border;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$photoorganizer$renderer$ThumbnailsPanel;

    public ThumbnailsPanel(Controller controller) {
        this.controller = controller;
        this.collectionpanel = (PhotoCollectionPanel)controller.component(Controller.COMP_COLLECTION);
        this.albumpanel = (AlbumPane)controller.component(Controller.COMP_ALBUMPANEL);
        this.setMinimumSize(Resources.MIN_PANEL_DIMENSION);
        this.setImageView();
        this.imagepanel.setThumbnailsPanel(this);
    }

    void setImageView() {
        this.imagepanel = (PhotoImagePanel)this.controller.component(Controller.COMP_IMAGEPANEL);
    }

    void calculateLayout() {
        Serializer serializer = this.controller.getSerializer();
        this.reg_border = ThumbnailsOptionsTab.createBorder((String)serializer.getProperty((Object)"ThumbnailsOptions", (Object)"Border"));
        this.selected_border = ThumbnailsOptionsTab.createBorder((String)serializer.getProperty((Object)"ThumbnailsOptions", (Object)"SelectedBorder"));
        Integer n = (Integer)serializer.getProperty((Object)"ThumbnailsOptions", (Object)"Vertical");
        this.v = 5;
        this.h = 0;
        if (n != null && n == 0) {
            n = (Integer)serializer.getProperty((Object)"ThumbnailsOptions", (Object)"FixedNumber");
            if (n != null) {
                this.v = 0;
                this.h = n;
            }
        } else {
            n = (Integer)serializer.getProperty((Object)"ThumbnailsOptions", (Object)"FixedNumber");
            if (n != null) {
                this.h = 0;
                this.v = n;
            }
        }
        this.sx = 162;
        this.sy = 142;
        n = (Integer)serializer.getProperty((Object)"ThumbnailsOptions", (Object)"CellWidth");
        if (n != null) {
            this.sx = n;
        } else {
            serializer.setProperty((Object)"ThumbnailsOptions", (Object)"CellWidth", (Object)new Integer(this.sx));
        }
        n = (Integer)serializer.getProperty((Object)"ThumbnailsOptions", (Object)"CellHeight");
        if (n != null) {
            this.sy = n;
        } else {
            serializer.setProperty((Object)"ThumbnailsOptions", (Object)"CellHeight", (Object)new Integer(this.sy));
        }
        this.setLayout(new GridLayout(this.h, this.v));
    }

    public Component createThumbnail(AbstractFormat abstractFormat) {
        return new ThumbnailComponent(abstractFormat);
    }

    public Dimension getPreferredSize() {
        return this.preferredsize;
    }

    public void updateImages(File file) {
        this.updateImages(new File[]{file});
    }

    public long getLength() {
        return this.length;
    }

    public int getTime() {
        return this.time;
    }

    public void removeAll() {
        super.removeAll();
        this.length = 0L;
        this.time = 0;
    }

    public boolean updateMedias(AbstractFormat[] abstractFormatArray) {
        this.removeAll();
        this.calculateLayout();
        boolean bl = false;
        int n = 0;
        while (n < abstractFormatArray.length) {
            if (this.isLowMemory(true)) break;
            if (abstractFormatArray[n] != null && abstractFormatArray[n].isValid()) {
                this.add(this.createThumbnail(abstractFormatArray[n]));
                bl |= true;
            }
            ++n;
        }
        this.adjustDimension();
        return bl;
    }

    public boolean updateImages(File[] fileArray) {
        this.removeAll();
        this.calculateLayout();
        boolean bl = false;
        int n = 0;
        while (n < fileArray.length) {
            if (this.isLowMemory(true)) break;
            if (fileArray[n].isFile()) {
                AbstractFormat abstractFormat = MediaFormatFactory.createMediaFormat(fileArray[n]);
                if (abstractFormat != null && abstractFormat.isValid()) {
                    this.add(this.createThumbnail(abstractFormat));
                    bl |= true;
                }
            } else if (fileArray[n].isDirectory() && fileArray.length == 1) {
                bl |= this.updateImages(fileArray[n].listFiles());
            }
            ++n;
        }
        this.adjustDimension();
        return bl;
    }

    public void addImage(AbstractFormat abstractFormat) {
        this.calculateLayout();
        this.add(this.createThumbnail(abstractFormat));
        this.adjustDimension();
    }

    public Component add(Component component) {
        Component component2 = super.add(component);
        if (component != null && component instanceof ThumbnailComponent) {
            AbstractFormat abstractFormat = ((ThumbnailComponent)component).getFormat();
            this.length += abstractFormat.getFileSize();
            if (abstractFormat.getType().equals("MP3")) {
                this.time = (int)((long)this.time + abstractFormat.getInfo().getLongAttribute("Length"));
            }
        }
        return component2;
    }

    public void remove(Component component) {
        super.remove(component);
        if (component != null && component instanceof ThumbnailComponent) {
            AbstractFormat abstractFormat = ((ThumbnailComponent)component).getFormat();
            this.length -= abstractFormat.getFileSize();
            if (abstractFormat.getType().equals("MP3")) {
                this.time = (int)((long)this.time - abstractFormat.getInfo().getLongAttribute("Length"));
            }
        }
    }

    public void addImage(File file) {
        this.calculateLayout();
        AbstractFormat abstractFormat = MediaFormatFactory.createMediaFormat(file);
        if (abstractFormat != null && abstractFormat.isValid()) {
            this.add(this.createThumbnail(abstractFormat));
        }
        this.adjustDimension();
    }

    void adjustDimension() {
        this.preferredsize = this.v != 0 ? new Dimension(this.v * this.sx, (this.getComponentCount() / this.v + 1) * this.sy) : new Dimension((this.getComponentCount() / this.h + 1) * this.sx, this.h * this.sy);
        this.setSize(this.preferredsize);
        this.revalidate();
        this.repaint();
    }

    JPopupMenu getRightButtonMenu(ActionListener actionListener, boolean bl) {
        return new FastMenu(actionListener, this.controller);
    }

    void doSpecificAction(AbstractFormat abstractFormat, ActionEvent actionEvent, Thumbnail thumbnail) {
        String string = actionEvent.getActionCommand();
        if (string.equals("To selection")) {
            this.collectionpanel.add(abstractFormat);
        } else if (string.equals("To album")) {
            AlbumSelectionDialog albumSelectionDialog = this.albumpanel.getSelectionDialog();
            albumSelectionDialog.setTitle("Albums selection for - :" + abstractFormat);
            albumSelectionDialog.setVisible(true);
            TreePath[] treePathArray = albumSelectionDialog.getSelectedAlbums();
            if (treePathArray != null) {
                this.albumpanel.addToAlbum(new BasicJpeg[]{(BasicJpeg)abstractFormat}, treePathArray);
                Serializer serializer = this.controller.getSerializer();
                if (Serializer.getInt((Object)serializer.getProperty((Object)"AlbumOptions", (Object)"MoveToAlbum"), (int)0) == 1 && Serializer.getInt((Object)serializer.getProperty((Object)"AlbumOptions", (Object)"AlbumFolders"), (int)0) == 1) {
                    // empty if block
                }
            }
        } else if (string.equals("Show/Play")) {
            this.showFullImage(abstractFormat, thumbnail);
        } else if (string.equals("Rename")) {
            Serializer serializer = this.controller.getSerializer();
            boolean bl = false;
            if (abstractFormat.isValid() && Serializer.getInt((Object)serializer.getProperty((Object)"RenameOptions", (Object)"AskEdit"), (int)0) == 0) {
                bl = abstractFormat.renameTo(new File(abstractFormat.getFile().getParent(), FileNameFormat.makeValidPathName(RenameOptionsTab.getNewName(abstractFormat, this.controller))));
            } else {
                Object object = abstractFormat.isValid() ? abstractFormat.getFile().getParent() + File.separatorChar + FileNameFormat.makeValidPathName(RenameOptionsTab.getNewName(abstractFormat, this.controller)) : abstractFormat.getFile();
                if ((object = JOptionPane.showInputDialog(this, "New name", "Rename", 3, null, null, object)) != null) {
                    bl = abstractFormat.renameTo(new File(object.toString()));
                }
            }
            if (bl) {
                thumbnail.update();
            }
        } else if (string.equals("Delete")) {
            Serializer serializer = this.controller.getSerializer();
            if (Serializer.getInt((Object)serializer.getProperty((Object)"MiscellaneousOptions", (Object)"ShowWarnDlg"), (int)0) == 1 && JOptionPane.showConfirmDialog(this, "Confirm deletions " + abstractFormat.getFile(), "Confirmation...", 2) != 0) {
                return;
            }
            if (abstractFormat.getFile().delete()) {
                this.remove((Component)((Object)thumbnail));
                this.adjustDimension();
            }
        } else if (string.equals("Print")) {
            this.controller.print(new File[]{abstractFormat.getFile()});
        }
    }

    public String getImageTitle(AbstractFormat abstractFormat, boolean bl) {
        String string = null;
        boolean bl2 = Serializer.getInt((Object)this.controller.getSerializer().getProperty((Object)"ThumbnailsOptions", (Object)"ShowComment"), (int)0) == 1;
        AbstractInfo abstractInfo = abstractFormat.getInfo();
        if (bl2) {
            try {
                string = abstractInfo.getAttribute("Comments") != null ? abstractInfo.getAttribute("Comments").toString() : null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.println("" + abstractFormat + ' ' + illegalArgumentException);
            }
        }
        if (string == null || string.length() == 0) {
            string = (String)this.controller.getSerializer().getProperty((Object)"ThumbnailsOptions", (Object)"LabelMask");
        }
        if (bl) {
            if (string != null) {
                try {
                    return new FileNameFormat(string).format(abstractFormat);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println("" + abstractFormat + ' ' + illegalArgumentException);
                }
            } else if (abstractInfo != null) {
                try {
                    return abstractInfo.getAttribute("DateTimeOriginal").toString();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return abstractInfo.toString();
                }
            }
        } else if (abstractInfo != null) {
            return "No thumbnail for " + abstractInfo.getAttribute("make");
        }
        return "No thumbnail for " + abstractFormat.getName();
    }

    void showFullImage(AbstractFormat abstractFormat, Thumbnail thumbnail) {
        if (abstractFormat != null && abstractFormat.isValid()) {
            if (abstractFormat instanceof BasicJpeg) {
                this.imagepanel.updateView(abstractFormat);
            } else if (abstractFormat instanceof MP3) {
                try {
                    this.controller.playMedia(abstractFormat, 0);
                }
                catch (IOException iOException) {
                    System.err.println("" + abstractFormat + ' ' + iOException);
                }
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
        this.controller.updateCaption(abstractFormat.getName());
        this.setCurrent(thumbnail);
    }

    public void setCurrent(Thumbnail thumbnail) {
        this.current_thumb = thumbnail;
    }

    public void showNext() {
        int n = 0;
        while (n < this.getComponentCount() - 1) {
            if (this.current_thumb == this.getComponent(n)) {
                Thumbnail thumbnail = (Thumbnail)((Object)this.getComponent(n + 1));
                this.doSpecificAction(thumbnail.getFormat(), new ActionEvent(thumbnail, 0, "Show/Play"), thumbnail);
                break;
            }
            ++n;
        }
    }

    public void showPrev() {
        int n = this.getComponentCount() - 1;
        while (n > 0) {
            if (this.current_thumb == this.getComponent(n)) {
                Thumbnail thumbnail = (Thumbnail)((Object)this.getComponent(n - 1));
                this.doSpecificAction(thumbnail.getFormat(), new ActionEvent(thumbnail, 0, "Show/Play"), thumbnail);
                break;
            }
            --n;
        }
    }

    protected boolean isLowMemory(boolean bl) {
        if (Controller.isLowMemory()) {
            if (bl) {
                JOptionPane.showMessageDialog(this, "The system runs on very low free memory, the current operation will be terminated.", "Error", 0);
            }
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$photoorganizer$renderer$ThumbnailsPanel == null ? (class$photoorganizer$renderer$ThumbnailsPanel = ThumbnailsPanel.class$("photoorganizer.renderer.ThumbnailsPanel")) : class$photoorganizer$renderer$ThumbnailsPanel).desiredAssertionStatus();
    }

    class ThumbnailComponent
    extends JLabel
    implements ActionListener,
    Thumbnail {
        Dimension preferredsize;
        Dimension thumbnailSize;
        private AbstractFormat format;

        public ThumbnailComponent() {
            super(new ImageIcon());
            this.preferredsize = new Dimension(ThumbnailsPanel.this.sx, ThumbnailsPanel.this.sy);
            this.thumbnailSize = new Dimension(this.preferredsize.width - 4, this.preferredsize.height - 4 - ThumbnailsPanel.this.labelTextHeight);
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(3);
            this.addMouseListener(new MouseInputAdapter(this){
                private final /* synthetic */ ThumbnailComponent this$1;
                {
                    this.this$1 = thumbnailComponent;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    int n = mouseEvent.getModifiers();
                    if (mouseEvent.getClickCount() == 2 && (n & 0x10) > 0) {
                        ThumbnailComponent.access$400(this.this$1).doSpecificAction(ThumbnailComponent.access$300(this.this$1), new ActionEvent(this.this$1, 0, "Show/Play"), this.this$1);
                    } else if ((n & 4) > 0) {
                        ThumbnailComponent.access$400(this.this$1).getRightButtonMenu(this.this$1, mouseEvent.isControlDown()).show(this.this$1, mouseEvent.getX(), ThumbnailComponent.access$400((ThumbnailComponent)this.this$1).controller.adjustMenuY(this.this$1.getLocationOnScreen().y + mouseEvent.getY(), 250) - this.this$1.getLocationOnScreen().y);
                    }
                }
            });
            this.setBorder(ThumbnailsPanel.this.reg_border);
        }

        public Dimension getPreferredSize() {
            return this.preferredsize;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Properties...")) {
                PropertiesPanel.showProperties(this.format, ThumbnailsPanel.this.controller);
            } else {
                ThumbnailsPanel.this.doSpecificAction(this.format, actionEvent, this);
            }
        }

        public ThumbnailComponent(AbstractFormat abstractFormat) {
            this();
            this.updateImage(abstractFormat);
        }

        void updateImage(AbstractFormat abstractFormat) {
            this.format = abstractFormat;
            String string = Serializer.arrayToString((Object)ThumbnailsPanel.this.controller.getSerializer().getProperty((Object)"ThumbnailsOptions", (Object)"ToolTipMask"));
            Icon icon = abstractFormat.getThumbnail(this.thumbnailSize);
            if (string != null) {
                this.setToolTipText(new FileNameFormat(string).format(abstractFormat));
            } else {
                this.setToolTipText(abstractFormat.getInfo().toString());
            }
            if (icon != null) {
                this.setIcon(icon);
                this.setText(ThumbnailsPanel.this.getImageTitle(abstractFormat, true));
            } else {
                this.setText(ThumbnailsPanel.this.getImageTitle(abstractFormat, false));
            }
        }

        public void paint(Graphics graphics) {
            try {
                super.paint(graphics);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public AbstractFormat getFormat() {
            return this.format;
        }

        public void select(boolean bl) {
            this.setBorder(bl ? ThumbnailsPanel.this.selected_border : ThumbnailsPanel.this.reg_border);
        }

        public void update() {
            this.updateImage(this.format);
        }

        public String toString() {
            return this.format.getName();
        }

        static /* synthetic */ AbstractFormat access$300(ThumbnailComponent thumbnailComponent) {
            return thumbnailComponent.format;
        }

        static /* synthetic */ ThumbnailsPanel access$400(ThumbnailComponent thumbnailComponent) {
            return thumbnailComponent.ThumbnailsPanel.this;
        }
    }
}

