/*
 * Decompiled with CFR 0.152.
 */
package de.vdheide.mp3;

import de.vdheide.mp3.ID3v2IllegalVersionException;
import de.vdheide.mp3.NoID3v2HeaderException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

public class ID3v2Header
implements Serializable {
    byte version = 0;
    byte revision = 0;
    boolean unsynch = false;
    boolean extended_header = false;
    boolean experimental = false;
    int size = 0;
    private static final byte FLAG_UNSYNCHRONIZATION = -128;
    private static final byte FLAG_EXTENDED_HEADER = 64;
    private static final byte FLAG_EXPERIMENTAL = 32;

    public ID3v2Header() {
        this(3, 0, false, false, false, 0);
    }

    public ID3v2Header(byte by, byte by2, boolean bl, boolean bl2, boolean bl3, int n) {
        this.version = by;
        this.revision = by2;
        this.unsynch = bl;
        this.extended_header = bl2;
        this.experimental = bl3;
        this.size = n;
    }

    public ID3v2Header(InputStream inputStream) throws ID3v2IllegalVersionException, NoID3v2HeaderException, IOException {
        this.readFromFile(inputStream);
    }

    public void readFromFile(InputStream inputStream) throws ID3v2IllegalVersionException, NoID3v2HeaderException, IOException {
        byte[] byArray = new byte[10];
        inputStream.read(byArray);
        if (!ID3v2Header.isHeader(byArray)) {
            throw new NoID3v2HeaderException();
        }
        this.version = byArray[3];
        this.revision = byArray[4];
        if ((this.version & 0xFF) > 3 || this.version == 3 && (this.revision & 0xFF) > 0) {
            throw new ID3v2IllegalVersionException();
        }
        this.unsynch = (byArray[5] & 0xFF & 0xFFFFFF80) > 0;
        this.extended_header = (byArray[5] & 0xFF & 0x40) > 0;
        this.experimental = (byArray[5] & 0xFF & 0x20) > 0;
        this.size = (byArray[9] & 0xFF) + ((byArray[8] & 0xFF) << 7) + ((byArray[7] & 0xFF) << 14) + ((byArray[6] & 0xFF) << 21);
    }

    public static boolean isHeader(byte[] byArray) {
        if (byArray.length != 10) {
            return false;
        }
        if (byArray[0] != 73 || byArray[1] != 68 || byArray[2] != 51) {
            return false;
        }
        if (byArray[3] == -1 || byArray[4] == -1) {
            return false;
        }
        return (byArray[6] & 0xFF) < 128 && (byArray[7] & 0xFF) < 128 && (byArray[8] & 0xFF) < 128 && (byArray[9] & 0xFF) < 128;
    }

    public boolean getUnsynchronization() {
        return this.unsynch;
    }

    public void setUnsynchronization(boolean bl) {
        this.unsynch = bl;
    }

    public boolean hasExtendedHeader() {
        return this.extended_header;
    }

    public void setExtendedHeader(boolean bl) {
        this.extended_header = bl;
    }

    public boolean getExperimental() {
        return this.experimental;
    }

    public void setExperimental(boolean bl) {
        this.experimental = bl;
    }

    public int getTagSize() {
        return this.size;
    }

    public void setTagSize(int n) {
        this.size = n;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[10];
        byArray[0] = 73;
        byArray[1] = 68;
        byArray[2] = 51;
        byArray[3] = this.version;
        byArray[4] = this.revision;
        int n = 0;
        if (this.unsynch) {
            n = (byte)(n - 128);
        }
        if (this.extended_header) {
            n = (byte)(n + 64);
        }
        if (this.experimental) {
            n = (byte)(n + 32);
        }
        byArray[5] = n;
        int n2 = 0;
        while (n2 < 4) {
            byArray[n2 + 6] = (byte)(this.size >> (3 - n2) * 7 & 0x7F);
            ++n2;
        }
        return byArray;
    }
}

