/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import tools.GraphXY;
import tools.ImageFamily;
import tools.TraceMonitor;
import tools.TypeConverter;
import tools.Var;
import tools.VarMonitor;
import tools.XY;

public final class Marker
implements Var {
    String name;
    GraphXY parent;
    public boolean dynamic = true;
    public boolean disabled;
    public boolean hidden;
    public boolean draggable;
    public boolean clickable;
    public boolean selectable;
    public boolean selected;
    public boolean dragged;
    public double ax;
    public double ay;
    public double x;
    public double y;
    public double xRel = Double.NaN;
    public double yRel = Double.NaN;
    public boolean orto;
    public int gap = 5;
    public Color foreColor = Color.black;
    public Color bordColor = Color.black;
    public Color backColor;
    public int dotR;
    public Color dotColor;
    public String t;
    public String fontName = "TimesRoman";
    public boolean fontBold = true;
    public boolean fontItalic = false;
    public int fontSize = 14;
    public String image;
    String pImage = "";
    ImageFamily img;
    public String href;
    public String radio;
    public String status;
    Rectangle rect;
    boolean pressed;

    public String getName() {
        return this.name;
    }

    public String getRadioGroup() {
        return this.radio;
    }

    public String getRadioField() {
        return "selected";
    }

    public Marker(String string) {
        this.name = string;
    }

    public Marker() {
    }

    public Object get(String string) {
        if ("dynamic".equals(string)) {
            return new Boolean(this.dynamic);
        }
        if ("disabled".equals(string)) {
            return new Boolean(this.disabled);
        }
        if ("hidden".equals(string)) {
            return new Boolean(this.hidden);
        }
        if ("draggable".equals(string)) {
            return new Boolean(this.draggable);
        }
        if ("clickable".equals(string)) {
            return new Boolean(this.clickable);
        }
        if ("selectable".equals(string)) {
            return new Boolean(this.selectable);
        }
        if ("selected".equals(string)) {
            return new Boolean(this.selected);
        }
        if ("foreColor".equals(string)) {
            return this.foreColor;
        }
        if ("bordColor".equals(string)) {
            return this.bordColor;
        }
        if ("backColor".equals(string)) {
            return this.backColor;
        }
        if ("x".equals(string)) {
            return new Double(this.x);
        }
        if ("y".equals(string)) {
            return new Double(this.y);
        }
        if ("xRel".equals(string)) {
            return new Double(this.xRel);
        }
        if ("yRel".equals(string)) {
            return new Double(this.yRel);
        }
        if ("orto".equals(string)) {
            return new Boolean(this.orto);
        }
        if ("gap".equals(string)) {
            return new Integer(this.gap);
        }
        if ("dotR".equals(string)) {
            return new Integer(this.dotR);
        }
        if ("dotColor".equals(string)) {
            return this.dotColor;
        }
        if ("image".equals(string)) {
            return this.image;
        }
        if ("t".equals(string)) {
            return this.t;
        }
        if ("fontName".equals(string)) {
            return this.fontName;
        }
        if ("fontSize".equals(string)) {
            return new Integer(this.fontSize);
        }
        if ("fontBold".equals(string)) {
            return new Boolean(this.fontBold);
        }
        if ("fontItalic".equals(string)) {
            return new Boolean(this.fontItalic);
        }
        if ("href".equals(string)) {
            return this.href;
        }
        if ("radio".equals(string)) {
            return this.radio;
        }
        if ("status".equals(string)) {
            return this.status;
        }
        return null;
    }

    public void set(Object object, String string) {
        if (!this.dynamic) {
            return;
        }
        if ("disabled".equals(string)) {
            this.disabled = TypeConverter.toBoolean(object);
        } else if ("hidden".equals(string)) {
            this.hidden = TypeConverter.toBoolean(object);
        } else if ("draggable".equals(string)) {
            this.draggable = TypeConverter.toBoolean(object);
        } else if ("clickable".equals(string)) {
            this.clickable = TypeConverter.toBoolean(object);
        } else if ("selectable".equals(string)) {
            this.selectable = TypeConverter.toBoolean(object);
        } else if ("selected".equals(string)) {
            this.selected = TypeConverter.toBoolean(object);
        } else if ("foreColor".equals(string)) {
            this.foreColor = object == null ? Color.black : (object instanceof Color ? (Color)object : TypeConverter.parseColor(object.toString(), Color.black));
        } else if ("bordColor".equals(string)) {
            this.bordColor = object == null ? Color.black : (object instanceof Color ? (Color)object : TypeConverter.parseColor(object.toString(), Color.black));
        } else if ("backColor".equals(string)) {
            this.backColor = object == null ? Color.black : (object instanceof Color ? (Color)object : TypeConverter.parseColor(object.toString(), Color.black));
        } else if ("x".equals(string)) {
            this.x = this.ax = TypeConverter.toDouble(object);
        } else if ("y".equals(string)) {
            this.y = this.ay = TypeConverter.toDouble(object);
        } else if ("xRel".equals(string)) {
            this.xRel = TypeConverter.toDouble(object);
        } else if ("yRel".equals(string)) {
            this.yRel = TypeConverter.toDouble(object);
        } else if ("orto".equals(string)) {
            this.orto = TypeConverter.toBoolean(object);
        } else if ("gap".equals(string)) {
            this.gap = TypeConverter.toInteger(object);
        } else if ("dotR".equals(string)) {
            this.dotR = TypeConverter.toInteger(object);
        } else if ("dotColor".equals(string)) {
            this.dotColor = object == null ? Color.black : (object instanceof Color ? (Color)object : TypeConverter.parseColor(object.toString(), Color.black));
        } else if ("image".equals(string)) {
            this.image = object == null ? "" : (!(object instanceof Double) ? object.toString() : TypeConverter.double2String((Double)object, 2, false, false, false, false));
        } else if ("t".equals(string)) {
            this.t = object == null ? "" : (!(object instanceof Double) ? object.toString() : TypeConverter.double2String((Double)object, 2, false, false, false, false));
        } else if ("fontName".equals(string)) {
            this.fontName = object == null ? "" : (!(object instanceof Double) ? object.toString() : TypeConverter.double2String((Double)object, 2, false, false, false, false));
        } else if ("fontSize".equals(string)) {
            this.fontSize = TypeConverter.toInteger(object);
        } else if ("fontBold".equals(string)) {
            this.fontBold = TypeConverter.toBoolean(object);
        } else if ("fontItalic".equals(string)) {
            this.fontItalic = TypeConverter.toBoolean(object);
        } else if ("href".equals(string)) {
            this.href = object == null ? "" : (!(object instanceof Double) ? object.toString() : TypeConverter.double2String((Double)object, 2, false, false, false, false));
        } else if ("radio".equals(string)) {
            this.radio = object == null ? "" : (!(object instanceof Double) ? object.toString() : TypeConverter.double2String((Double)object, 2, false, false, false, false));
        } else if ("status".equals(string)) {
            String string2 = object == null ? "" : (this.status = !(object instanceof Double) ? object.toString() : TypeConverter.double2String((Double)object, 2, false, false, false, false));
        }
        if (Thread.currentThread() != this.parent.thread) {
            this.parent.incEventsCount();
        }
    }

    void click() {
        if (this.clickable) {
            TraceMonitor.event(this.name);
            TraceMonitor.eventGo(this.href);
            return;
        }
        if (this.selectable) {
            this.selected = !this.selected;
            VarMonitor.radio(this);
            TraceMonitor.event(this.name);
            return;
        }
    }

    void drag() {
        if (this.draggable) {
            TraceMonitor.event(this.name);
        }
    }

    void draw(Graphics graphics, GraphXY graphXY) {
        Color color;
        int n;
        int n2;
        int n3;
        if (this.hidden || Double.isNaN(this.x) || Double.isNaN(this.y)) {
            this.rect = null;
            return;
        }
        if (this.image != null && !this.pImage.equals(this.image)) {
            this.img = new ImageFamily(this.image, graphXY);
            this.pImage = this.image;
        }
        int n4 = 0;
        int n5 = 0;
        Image image = null;
        if (this.img != null) {
            image = this.img.getSource();
            if (this == graphXY.activeMarker) {
                image = this.img.getBright();
            }
            if (this.disabled) {
                image = this.img.getContour();
            }
            if (image != null) {
                n4 = image.getWidth(graphXY);
                n5 = image.getHeight(graphXY);
                if (n4 < 0 || n5 < 0) {
                    image = null;
                    n5 = 0;
                    n4 = 0;
                }
            }
        }
        int n6 = 0;
        int n7 = 0;
        Font font = graphics.getFont();
        if (this.t != null) {
            n3 = 0;
            if (this.fontItalic) {
                n3 += 2;
            }
            if (this.fontBold) {
                ++n3;
            }
            graphics.setFont(new Font(this.fontName, n3, this.fontSize));
            n6 = graphics.getFontMetrics().stringWidth(this.t);
            n7 = (int)((double)this.fontSize / 1.5 + 3.5);
        }
        n3 = Math.max(n4, n6);
        int n8 = Math.max(n5, n7);
        if (n3 == 0 || n8 == 0) {
            n3 = n8 = this.gap;
        }
        XY xY = new XY(this.x, this.y);
        Point point = graphXY.XY2Point(xY);
        XY xY2 = new XY(Double.isNaN(this.xRel) ? this.x : this.xRel, Double.isNaN(this.yRel) ? this.y : this.yRel);
        Point point2 = graphXY.XY2Point(xY2);
        int n9 = point.x - point2.x;
        int n10 = point.y - point2.y;
        if (this.orto) {
            n2 = n9;
            n9 = n10;
            n10 = -n2;
        }
        n2 = n9 > 0 ? 1 : -1;
        int n11 = n10 > 0 ? 1 : -1;
        double d = Math.abs((double)n9);
        double d2 = Math.abs((double)n10);
        int n12 = 0;
        int n13 = 0;
        if (d < 1.0 && d2 >= 1.0) {
            n12 = 0;
            n13 = n8 / 2 + this.gap + this.dotR;
        }
        if (d >= 1.0 && d2 < 1.0) {
            n13 = 0;
            n12 = n3 / 2 + this.gap + this.dotR;
        }
        if (d >= 1.0 && d2 >= 1.0) {
            double d3 = (double)(n8 / 2 + this.gap + this.dotR) * d / d2;
            double d4 = (double)(n3 / 2 + this.gap + this.dotR) * d2 / d;
            if (d3 > d4) {
                n12 = n3 / 2 + this.gap + this.dotR;
                n13 = (int)d4;
            } else {
                n13 = n8 / 2 + this.gap + this.dotR;
                n12 = (int)d3;
            }
        }
        Point point3 = new Point(point.x + n12 * n2, point.y + n13 * n11);
        Color color2 = this.backColor;
        if (color2 != null) {
            if (this.disabled) {
                color2 = Color.lightGray;
            } else if (this == graphXY.activeMarker) {
                color2 = this.getBrighterColor(color2);
            }
            graphics.setColor(color2);
            graphics.fillRect(point3.x - n3 / 2, point3.y - n8 / 2, n3, n8);
        }
        int n14 = n = this.clickable && this.pressed ? 1 : 0;
        if (image != null) {
            graphics.drawImage(image, point3.x - n4 / 2 + n, point3.y - n5 / 2 + n, graphXY);
        }
        if (this.t != null) {
            if (!this.disabled) {
                graphics.setColor(this.foreColor == null ? Color.black : this.foreColor);
                graphics.drawString(this.t, point3.x - n6 / 2 + n, point3.y + n7 / 2 - 1 + n);
            } else {
                graphics.setColor(Color.white);
                graphics.drawString(this.t, point3.x - n6 / 2 + n, point3.y + n7 / 2 - 1 + n);
                graphics.setColor(Color.gray);
                graphics.drawString(this.t, point3.x - n6 / 2 + n - 1, point3.y + n7 / 2 - 1 + n - 1);
            }
        }
        if (this.dotR > 0) {
            color = this.dotColor != null ? this.dotColor : (this.foreColor != null ? this.foreColor : Color.black);
            graphics.setColor(color);
            graphics.fillOval(point.x - this.dotR, point.y - this.dotR, 2 * this.dotR, 2 * this.dotR);
        }
        if (this.clickable && this == graphXY.activeMarker && !this.disabled) {
            if (color2 == null) {
                color2 = Color.lightGray;
            }
            color = color2.darker();
            Color color3 = color2.brighter();
            int n15 = point3.x - n3 / 2;
            int n16 = point3.x + n3 / 2;
            int n17 = point3.y - n8 / 2;
            int n18 = point3.y + n8 / 2;
            graphics.setColor(this.pressed ? color : color3);
            graphics.drawLine(n15, n17, n15, n18 - 1);
            graphics.drawLine(n15, n17, n16 - 1, n17);
            graphics.setColor(!this.pressed ? color : color3);
            graphics.drawLine(n16, n18, n16, n17 + 1);
            graphics.drawLine(n16, n18, n15 + 1, n18);
        }
        if (this.selected) {
            graphics.setColor(this.bordColor == null ? Color.black : this.bordColor);
            graphics.drawRect(point3.x - 1 - n3 / 2 - 1, point3.y - 1 - n8 / 2 - 1, n3 + 3, n8 + 3);
            graphics.drawRect(point3.x - 1 - n3 / 2 - 2, point3.y - 1 - n8 / 2 - 2, n3 + 5, n8 + 5);
        }
        this.rect = this.draggable || this.clickable || this.selectable ? (this.dotR > 0 ? new Rectangle(point.x - this.dotR - 1, point.y - this.dotR - 1, 2 * this.dotR + 1, 2 * this.dotR + 1) : new Rectangle(point3.x - 1 - n3 / 2, point3.y - 1 - n8 / 2, n3 + 1, n8 + 1)) : null;
        if ((this.draggable || this.selectable) && this == graphXY.activeMarker) {
            graphics.setColor(this.bordColor == null ? Color.black : this.bordColor);
            graphics.drawRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
        }
        if (this.t != null) {
            graphics.setFont(font);
        }
    }

    Color getBrighterColor(Color color) {
        if (color == null) {
            return null;
        }
        if (Toolkit.getDefaultToolkit().getColorModel().getPixelSize() < 16) {
            return color;
        }
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        n += n >> 4;
        n2 += n2 >> 4;
        n3 += n3 >> 4;
        if (n > 255) {
            n = 255;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        if (n3 > 255) {
            n3 = 255;
        }
        return new Color(n, n2, n3);
    }

    boolean isLoaded(boolean bl) {
        if (this.dynamic ^ bl) {
            return true;
        }
        if (this.image == null || this.image.trim().length() == 0) {
            return true;
        }
        if (this.img == null) {
            return false;
        }
        ImageFamily imageFamily = this.img;
        return imageFamily.mt == null || imageFamily.mt.checkID(0, true);
    }
}

