@echo off
cls
echo ----------------------------------------------------------------------
echo.
echo                       SortTxtFile.bat  V1.00
echo                          by Matthias Klumpp
echo ----------------------------------------------------------------------
echo This tool sorts the given input file by alphabetical order and
echo writes the result to the given output file.
echo.
echo It only works with files in ASCII text format.
echo Don't use this program to sort e.g. DOC files.
echo.
echo ----------------------------------------------------------------------
echo.

if "%1" == "" goto WRONG_PARAMETER
if "%2" == "" goto WRONG_PARAMETER

if exist c:\winnt\system32\sort.exe  goto NT_SORT
if exist c:\windows\command\sort.exe goto 9X_SORT

goto OS_NOT_RECOGNIZED
goto END

:NT_SORT
echo Sort in process...
c:\winnt\system32\sort.exe < "%1" > "%2"
echo Sort ended.
echo.
goto END

:9X_SORT
echo Sort in process...
c:\windows\command\sort.exe < "%1" > "%2"
echo Sort ended.
echo.
goto END

:WRONG_PARAMETER
echo.
echo **********************************************************************
echo ERROR:   Wrong parameter usage !
echo.
echo Syntax:  SortTxtFile [input file].[ext] [output file].[ext]
echo **********************************************************************
echo.
goto END


:OS_NOT_RECOGNIZED
echo.
echo **********************************************************************
echo ERROR: Unknown operating system !
echo **********************************************************************
echo.
goto END


:END
pause
