/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Value;

import X10Gimli.Debug;
import X10Gimli.System.EnvironmentSmall;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueNothing;
import X10Gimli.Value.ValueType;

public final class ValueBoolean
extends Value {
    private boolean bBool;

    public ValueBoolean() {
    }

    public ValueBoolean(String string) {
        this.setValueString(string.toUpperCase());
        this.setBoolean(this.getValueString());
    }

    public ValueBoolean(boolean bool) {
        this.setBoolean(bool);
    }

    public void setBoolean(boolean bool) {
        this.bBool = bool;
        this.makeString();
    }

    public void setBoolean(String bool) {
        this.bBool = bool.equals("TRUE");
        this.makeString();
    }

    public boolean getBoolean() {
        return this.bBool;
    }

    public Value applyArithmetic(String op, ValueType val, EnvironmentSmall env) {
        Debug.error(102, "(Runtime) Incompatible arithmetic operation for BOOLEAN type.");
        return ValueNothing.value;
    }

    public int compareTo(ValueType val, EnvironmentSmall env) {
        Value cmp = val.getValue(env);
        if (cmp instanceof ValueBoolean) {
            if (this.getBoolean() == cmp.getBoolean()) {
                return 0;
            }
            return 100;
        }
        Debug.error(101, "(Runtime) Incompatible type comparison for conditional BOOLEAN operation : ".concat(String.valueOf(String.valueOf(cmp.string))));
        return 100;
    }

    public Value applyLogic(String op, ValueType val, EnvironmentSmall env) {
        Value cmp = val.getValue(env);
        if (cmp instanceof ValueBoolean) {
            if (op.equals("AND")) {
                return new ValueBoolean(cmp.getBoolean() && this.getBoolean());
            }
            if (op.equals("OR")) {
                return new ValueBoolean(cmp.getBoolean() || this.getBoolean());
            }
        }
        Debug.error(101, "(WARNING) Incompatible type comparison for logical BOOLEAN operation.");
        return new ValueBoolean(false);
    }

    public String toString() {
        if (this.bBool) {
            return "TRUE";
        }
        return "FALSE";
    }

    public String toX10GIMLI() {
        return this.toString();
    }
}

