/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Command;

import X10Gimli.Debug;
import X10Gimli.Parser;
import X10Gimli.System.Environment;
import X10Gimli.System.EnvironmentSmall;
import X10Gimli.Value.ValueType;

public abstract class Command {
    protected static char[] sBytes = new char[500];
    protected StringBuffer sBuf = new StringBuffer(new String(sBytes));

    public void doOutput(EnvironmentSmall env) {
        this.prepareOutput(env);
        this.executionOutput();
        Debug.log(4, this.sBuf.toString());
    }

    protected void prepareOutputDepth(int depth) {
        int indent = depth * 2;
        this.sBuf.setLength(0);
        this.sBuf.append(sBytes, 0, indent);
    }

    protected void prepareOutput(EnvironmentSmall env) {
        this.prepareOutputDepth(env.depth());
    }

    protected abstract void executionOutput();

    public abstract ValueType execute(EnvironmentSmall var1);

    public String toString() {
        this.sBuf.setLength(0);
        this.executionOutput();
        return this.sBuf.toString();
    }

    public abstract String toX10GIMLI(int var1);

    public static ValueType executeString(String commandString, Environment env) {
        Parser p = new Parser();
        p.setInputString(commandString);
        Command input = p.productionCommand();
        EnvironmentSmall e = env != null ? env.spawnEnvironment() : new Environment();
        return e.executeCommand(input);
    }

    static {
        for (int i = 0; i < 500; ++i) {
            Command.sBytes[i] = 32;
        }
    }
}

