
/*
 * Copyright (c) 1998, 1999 Semiotek Inc. All Rights Reserved.
 *
 * This software is the confidential intellectual property of
 * of Semiotek Inc.; it is copyrighted and licensed, not sold.
 * You may use it under the terms of the GNU General Public License,
 * version 2, as published by the Free Software Foundation. If you 
 * do not want to use the GPL, you may still use the software after
 * purchasing a proprietary developers license from Semiotek Inc.
 *
 * This software is provided "as is", with NO WARRANTY, not even the 
 * implied warranties of fitness to purpose, or merchantability. You
 * assume all risks and liabilities associated with its use.
 *
 * See the attached License.html file for details, or contact us
 * by e-mail at info@semiotek.com to get a copy.
 */


package org.webmacro.engine;

import org.webmacro.util.*;

/**
  * Exception raised on discovery of a parsing error. To facilitate error
  * recovery, you can extract the parseTool from this error. 
  */
public final class ParseException extends Exception
{

   /**
     * We store the parseTool to assist with error recovery
     */
   private ParseTool in;

   /**
     * Create a new exception
     * <p>
     * @param in the parseTool we were reading that contained unparasable data
     * @param reason what exactly failed in our attempt to parse it
     */
   public ParseException(ParseTool in, String reason) 
   {
      super(((in != null) ? in.toString() : "input source unknown" ) + ": " + reason);
      this.in = in;
   }

   /**
     * Return the parseTool that contained the unparsable data
     */
   final ParseTool getParseTool() {
      return in;
   }

   /**
     * Test harness
     */
   static public void main(String arg[]) {

      try {
         Log.setLevel(Log.EXCEPTION);
         Log.traceExceptions(true);
         ParseTool in = new ParseTool("string",
               new java.io.StringReader(
                  "one\nday\nat\na\ntime" //parseTool fixes port. problem here 
                  )); 

         while (in.ttype != in.TT_EOF) {
            in.nextToken();
            if (in.ttype == in.TT_WORD) {
               System.out.println("Got token: [" + in.sval + "]");
               if (in.sval.equals("at")) {
                  break;
               }
            } else {
               System.out.println("Got token: " + in.ttype);
            }
         }
         throw new ParseException(in,"Test exception on line three");
      } catch (ParseException e) {
         System.out.println("Caught it.");
      } catch (Exception e) {
         System.out.println("Caught the wrong exception.");
         e.printStackTrace();
      }
   }

}
