/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import org.webmacro.util.Accessor;
import org.webmacro.util.ArrayIterator;
import org.webmacro.util.BinaryMethodAccessor;
import org.webmacro.util.DirectAccessor;
import org.webmacro.util.EnumIterator;
import org.webmacro.util.FieldAccessor;
import org.webmacro.util.InvalidContextException;
import org.webmacro.util.Log;
import org.webmacro.util.MethodAccessor;
import org.webmacro.util.PropertyException;
import org.webmacro.util.PropertyMethod;
import org.webmacro.util.UnaryMethodAccessor;
import org.webmacro.util.java2.Iterator;

public final class PropertyOperator {
    static final boolean _debug = false;
    static final Log _log = new Log("prop", "Property Introspection");
    private static final Hashtable _operators = new Hashtable();
    private static /* synthetic */ Class class$Lorg$webmacro$util$java2$Iterator;
    private static /* synthetic */ Class array$Ljava$lang$Object;
    private static /* synthetic */ Class class$Ljava$util$Enumeration;
    private final Hashtable _unaryAccessors = new Hashtable();
    private final Hashtable _binaryAccessors = new Hashtable();
    private final Hashtable _directAccessors = new Hashtable();
    private BinaryMethodAccessor hashAccessor;
    private Method iteratorMethod = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Object getProperty(Object object, Object[] objectArray) throws PropertyException, SecurityException, InvalidContextException {
        try {
            return PropertyOperator.getOperator(object.getClass()).getProperty(object, object, objectArray, 0, objectArray.length - 1);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            _log.exception(noSuchMethodException);
            throw new PropertyException("No method to access property: " + noSuchMethodException, noSuchMethodException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean setProperty(Object object, Object[] objectArray, Object object2) throws PropertyException, SecurityException, InvalidContextException {
        try {
            return PropertyOperator.getOperator(object.getClass()).setProperty(object, object, objectArray, object2, 0);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new PropertyException("No method to access property: " + noSuchMethodException, noSuchMethodException);
        }
    }

    public static final Iterator getIterator(Object object) throws PropertyException {
        return PropertyOperator.getOperator(object.getClass()).findIterator(object);
    }

    private static final PropertyOperator getOperator(Class clazz) throws PropertyException {
        PropertyOperator propertyOperator = (PropertyOperator)_operators.get(clazz);
        if (propertyOperator == null) {
            propertyOperator = new PropertyOperator(clazz);
            _operators.put(clazz, propertyOperator);
        }
        return propertyOperator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Object getProperty(Object object, Object object2, Object[] objectArray, int n, int n2) throws PropertyException, NoSuchMethodException, InvalidContextException {
        String string;
        Object object3 = null;
        Accessor accessor = null;
        if (objectArray[n] instanceof String) {
            string = (String)objectArray[n];
        } else if (objectArray[n] instanceof PropertyMethod) {
            PropertyMethod propertyMethod = (PropertyMethod)objectArray[n];
            string = propertyMethod.getName();
            accessor = (Accessor)this._directAccessors.get(string);
            Object[] objectArray2 = propertyMethod.getArguments(object);
            try {
                object3 = accessor.get(object2, objectArray2);
                ++n;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new NoSuchMethodException("No method " + propertyMethod + " on object " + object2);
            }
        } else {
            string = objectArray[n].toString();
        }
        if (accessor == null && (accessor = (Accessor)this._unaryAccessors.get(string)) != null) {
            try {
                object3 = accessor.get(object2);
                ++n;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                accessor = null;
            }
        }
        if (accessor == null) {
            accessor = (Accessor)this._binaryAccessors.get(string);
            if (accessor != null && n + 1 <= n2) {
                try {
                    object3 = accessor.get(object2, (String)objectArray[n + 1]);
                    n += 2;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    accessor = null;
                }
                catch (ClassCastException classCastException) {
                    accessor = null;
                }
            } else {
                accessor = null;
            }
        }
        if (accessor == null) {
            accessor = this.hashAccessor;
            try {
                if (accessor != null) {
                    object3 = accessor.get(object2, string);
                    ++n;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                accessor = null;
            }
        }
        if (accessor == null) {
            throw new NoSuchMethodException("No public method on object " + object2 + " of " + object2.getClass() + " for property " + objectArray[n] + "--is this the right class?");
        }
        if (n > n2) {
            return object3;
        }
        try {
            return PropertyOperator.getOperator(object3.getClass()).getProperty(object, object3, objectArray, n, n2);
        }
        catch (NullPointerException nullPointerException) {
            throw new PropertyException("No way to access property " + objectArray[n] + " on object " + object2 + " of " + object2.getClass() + "--possibly null?", nullPointerException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean setProperty(Object object, Object object2, Object[] objectArray, Object object3, int n) throws PropertyException, NoSuchMethodException, InvalidContextException {
        int n2 = objectArray.length - 1;
        int n3 = n2 - 1;
        if (n < n3) {
            Object object4 = this.getProperty(object, object2, objectArray, n, n3 - 1);
            PropertyOperator propertyOperator = PropertyOperator.getOperator(object4.getClass());
            return propertyOperator.setProperty(object, object4, objectArray, object3, n3);
        }
        if (n == n3) {
            Object object5;
            Object object6 = null;
            try {
                object6 = this.getProperty(object, object2, objectArray, n, n);
                if (object6 != null && super.setProperty(object, object6, objectArray, object3, n + 1)) {
                    return true;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            object5 = (Accessor)this._binaryAccessors.get(objectArray[n]);
            if (object5 == null) return false;
            try {
                return ((Accessor)object5).set(object2, (String)objectArray[n + 1], object3);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return false;
            }
        }
        Accessor accessor = (Accessor)this._unaryAccessors.get(objectArray[n]);
        try {
            if (accessor != null && accessor.set(object2, object3)) {
                return true;
            }
            if (this.hashAccessor == null) return false;
            return this.hashAccessor.set(object2, (String)objectArray[n], object3);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        catch (ClassCastException classCastException) {
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Iterator findIterator(Object object) throws PropertyException {
        if (object instanceof Object[]) {
            return new ArrayIterator((Object[])object);
        }
        if (object instanceof Iterator) {
            return (Iterator)object;
        }
        if (object instanceof Enumeration) {
            return new EnumIterator((Enumeration)object);
        }
        if (this.iteratorMethod == null) throw new PropertyException(object + " is not a list", null);
        try {
            Object object2 = PropertyOperator.invoke(this.iteratorMethod, object, null);
            if (object2 instanceof Iterator) {
                return (Iterator)object2;
            }
            if (object2 instanceof Enumeration) {
                return new EnumIterator((Enumeration)object2);
            }
            if (!(object2 instanceof Object[])) throw new PropertyException(object + " is not a list", null);
            return new ArrayIterator((Object[])object2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new PropertyException("Error in PropertyOperator!", noSuchMethodException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final Object invoke(Method method, Object object, Object[] objectArray) throws PropertyException, NoSuchMethodException {
        try {
            return method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PropertyException("You don't have permission to access the requested method (" + method + " in class " + object.getClass() + " on object " + object + "). Private/protected/package access " + " values cannot be accessed via property introspection.", illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new PropertyException("Some kind of error occurred processing your request: this " + "indicates a failure in PropertyOperator.java that should be " + "reported: attempt to access method " + method + " on object " + object + " with " + objectArray.length + " parameters " + " threw an exception: " + illegalArgumentException, illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new PropertyException("Attempt to invoke method " + method + " on object " + object + " of " + object.getClass() + " raised an exception: " + invocationTargetException.getTargetException(), invocationTargetException.getTargetException());
        }
        catch (NullPointerException nullPointerException) {
            if (method == null) {
                throw new NoSuchMethodException("Null method");
            }
            throw new PropertyException("NullPointerException thrown from method " + method + " on object " + object + " -- most likely you have attempted " + "to use an undefined value, or a failure in that method.", nullPointerException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private PropertyOperator(Class clazz) throws SecurityException, PropertyException {
        Accessor accessor;
        Field[] fieldArray = clazz.getFields();
        int n = 0;
        while (n < fieldArray.length) {
            if (Modifier.isPublic(fieldArray[n].getModifiers())) {
                accessor = new FieldAccessor(fieldArray[n]);
                this._unaryAccessors.put(accessor.getName(), accessor);
            }
            ++n;
        }
        Method[] methodArray = clazz.getMethods();
        int n2 = 0;
        while (n2 < methodArray.length) {
            Method method = methodArray[n2];
            if (Modifier.isPublic(method.getModifiers())) {
                Class<?> clazz2;
                String string = method.getName();
                Class[] classArray = method.getParameterTypes();
                int n3 = classArray.length;
                accessor = (Accessor)this._directAccessors.get(string);
                if (accessor != null) {
                    ((DirectAccessor)accessor).addMethod(method, classArray);
                } else {
                    accessor = new DirectAccessor(string, method, classArray);
                    this._directAccessors.put(string, accessor);
                }
                if (string.startsWith("get") || string.startsWith("set") || string.equals("put")) {
                    String string2 = string.substring(3);
                    if (n3 == 0 && string.startsWith("get") || n3 == 1 && string.startsWith("set")) {
                        accessor = (Accessor)this._unaryAccessors.get(string2);
                        if (accessor != null) {
                            if (accessor instanceof MethodAccessor) {
                                ((MethodAccessor)accessor).addMethod(method, classArray);
                            }
                        } else {
                            accessor = new UnaryMethodAccessor(string2, method, classArray);
                            this._unaryAccessors.put(string2, accessor);
                        }
                    } else if (n3 > 0 && (classArray[0].isInstance("string") && n3 == 2 && string.equals("put") || n3 == 1 && string.equals("get"))) {
                        if (this.hashAccessor != null) {
                            this.hashAccessor.addMethod(method, classArray);
                        } else {
                            this.hashAccessor = new BinaryMethodAccessor(string2, method, classArray);
                        }
                    } else if (n3 > 0 && classArray[0].isInstance("string") && (n3 == 1 && string.startsWith("get") || n3 == 2 && string.startsWith("set"))) {
                        accessor = (Accessor)this._binaryAccessors.get(string2);
                        if (accessor != null) {
                            ((MethodAccessor)accessor).addMethod(method, classArray);
                        } else {
                            accessor = new BinaryMethodAccessor(string2, method, classArray);
                            this._binaryAccessors.put(string2, accessor);
                        }
                    }
                } else if ((string.equals("elements") || string.equals("enumeration") || string.equals("iterator") || string.equals("toArray")) && classArray.length == 0 && ((class$Lorg$webmacro$util$java2$Iterator != null ? class$Lorg$webmacro$util$java2$Iterator : PropertyOperator.class$("org.webmacro.util.java2.Iterator")).isAssignableFrom(clazz2 = method.getReturnType()) || (this.iteratorMethod == null || this.iteratorMethod.getName().equals("toArray")) && (array$Ljava$lang$Object != null ? array$Ljava$lang$Object : PropertyOperator.class$("[Ljava.lang.Object;")).isAssignableFrom(clazz2) || (class$Ljava$util$Enumeration != null ? class$Ljava$util$Enumeration : PropertyOperator.class$("java.util.Enumeration")).isAssignableFrom(clazz2))) {
                    this.iteratorMethod = method;
                }
            }
            ++n2;
        }
    }
}

