/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Vector;
import org.webmacro.engine.Macro;
import org.webmacro.engine.ParseException;
import org.webmacro.engine.ParseTool;
import org.webmacro.engine.Term;
import org.webmacro.util.InvalidContextException;

public class List
implements Macro {
    private final Object[] _content;

    public static final Object parse(ParseTool parseTool) throws ParseException, IOException {
        Object object;
        int n;
        switch (parseTool.ttype) {
            case 40: {
                n = 41;
                break;
            }
            case 91: {
                n = 93;
                break;
            }
            default: {
                return null;
            }
        }
        Vector<Object> vector = new Vector<Object>();
        parseTool.nextToken();
        parseTool.parseSpaces();
        boolean bl = false;
        while ((object = Term.parse(parseTool)) != null) {
            if (object instanceof Macro) {
                bl = true;
            }
            vector.addElement(object);
            parseTool.parseSpaces();
            if (!parseTool.parseChar(',')) continue;
            parseTool.parseSpaces();
        }
        if (!parseTool.parseChar((char)n)) {
            throw new ParseException(parseTool, "Expected end of list, instead got " + (char)parseTool.ttype);
        }
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        if (bl) {
            return new List(objectArray);
        }
        return objectArray;
    }

    public void write(Writer writer, Object object) throws InvalidContextException, IOException {
        writer.write(this.evaluate(object).toString());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        int n = 0;
        while (n < this._content.length) {
            if (n != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this._content[n].toString());
            ++n;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public Object evaluate(Object object) throws InvalidContextException {
        Object[] objectArray = new Object[this._content.length];
        int n = 0;
        while (n < this._content.length) {
            Object object2 = this._content[n];
            if (object2 instanceof Macro) {
                object2 = ((Macro)object2).evaluate(object);
            }
            objectArray[n] = object2;
            ++n;
        }
        return objectArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        try {
            String[] stringArray2 = new String[]{"( one, two, \"three has text\", $four.has.fields, 'five has single quotes' )", "[one two three]", "( )", "( one, two, three ]"};
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("test", "this is the value of test");
            int n = 0;
            while (true) {
                if (n >= stringArray2.length) {
                    return;
                }
                System.out.println("Test case: " + stringArray2[n]);
                ParseTool parseTool = new ParseTool(stringArray2[n], new StringReader(stringArray2[n]));
                parseTool.nextToken();
                try {
                    Object object = List.parse(parseTool);
                    if (object instanceof Macro) {
                        object = ((Macro)object).evaluate(hashtable);
                    }
                    System.out.println(object.getClass());
                    Object[] objectArray = (Object[])object;
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        System.out.println("  term: " + objectArray[n2]);
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("ERROR: ");
            exception.printStackTrace();
        }
    }

    List(Object[] objectArray) {
        this._content = objectArray;
    }
}

