/*
 * Decompiled with CFR 0.152.
 */
package com.unipro.products.smgui;

import com.unipro.products.smgui.ACKsTableModel;
import com.unipro.products.smgui.MainFrame;
import com.unipro.products.smgui.MessagesTableModel;
import com.unipro.products.smgui.RecipientsComboBoxModel;
import com.unipro.products.smgui.Settings;
import com.unipro.smlib.Configurator;
import com.unipro.smlib.MobileException;
import com.unipro.smlib.PortConnectionException;
import com.unipro.smlib.SmsManager;
import com.unipro.smlib.ValidationException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class SMGUIApplication {
    private static String ACKS_FILE_NAME = "acks.dat";
    private static String MESSAGES_FILE_NAME = "messages.dat";
    private static String SETTINGS_FILE_NAME = "settings.dat";
    private static String RECIPIENTS_FILE_NAME = "recipients.dat";
    private static String DEFAULT_PORT = Configurator.PORT_COM3;
    private static int DEFAULT_BAUD = Configurator.BAUD_19200;
    public static String DEFAULT_SMSC_NUMBER = "79029869990";
    public static String MOBILES_URL = "http://mobiles.unipro.ru/smlib";
    public static String APPLICATION_VERSION = "2.0";
    boolean packFrame = false;
    public static SmsManager smsManager;
    public static Settings settings;
    public static MessagesTableModel messagesTableModel;
    public static ACKsTableModel acksTableModel;
    public static RecipientsComboBoxModel recipientsModel;
    static /* synthetic */ Class class$com$unipro$products$smgui$RecipientsComboBoxModel;
    static /* synthetic */ Class class$com$unipro$products$smgui$Settings;
    static /* synthetic */ Class class$java$util$Vector;

    public SMGUIApplication() throws Exception {
        MainFrame frame = new MainFrame();
        if (this.packFrame) {
            frame.pack();
        } else {
            frame.validate();
        }
        SMGUIApplication.centerFrame(frame);
        frame.setVisible(true);
        try {
            smsManager.init(new Configurator(settings.getPortName(), Integer.parseInt(settings.getPortBaud())));
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(frame, ex.getLocalizedMessage(), "Error", 0);
        }
        smsManager.addMessageListener(frame);
        smsManager.addACKListener(frame);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SMGUIApplication.init();
            new SMGUIApplication();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void clearAll() {
        messagesTableModel.clearData();
        messagesTableModel.fireTableDataChanged();
        acksTableModel.clearData();
        acksTableModel.fireTableDataChanged();
        recipientsModel.removeAllElements();
    }

    public static void clearMessageTable() {
        messagesTableModel.clearData();
        messagesTableModel.fireTableDataChanged();
    }

    public static void clearACKTable() {
        acksTableModel.clearData();
        acksTableModel.fireTableDataChanged();
    }

    public static void onFinish() {
        smsManager.close();
        SMGUIApplication.save(SETTINGS_FILE_NAME, settings);
        SMGUIApplication.save(RECIPIENTS_FILE_NAME, recipientsModel);
        SMGUIApplication.save(MESSAGES_FILE_NAME, messagesTableModel.getDataVector());
        SMGUIApplication.save(ACKS_FILE_NAME, acksTableModel.getDataVector());
    }

    private static void init() {
        smsManager = SmsManager.getInstance();
        recipientsModel = (RecipientsComboBoxModel)SMGUIApplication.load(RECIPIENTS_FILE_NAME, class$com$unipro$products$smgui$RecipientsComboBoxModel == null ? (class$com$unipro$products$smgui$RecipientsComboBoxModel = SMGUIApplication.class$("com.unipro.products.smgui.RecipientsComboBoxModel")) : class$com$unipro$products$smgui$RecipientsComboBoxModel);
        if (recipientsModel == null) {
            recipientsModel = new RecipientsComboBoxModel();
        }
        Vector messagesVector = (Vector)SMGUIApplication.load(MESSAGES_FILE_NAME, class$java$util$Vector == null ? (class$java$util$Vector = SMGUIApplication.class$("java.util.Vector")) : class$java$util$Vector);
        messagesTableModel = messagesVector == null ? new MessagesTableModel() : new MessagesTableModel(messagesVector);
        Vector acksVector = (Vector)SMGUIApplication.load(ACKS_FILE_NAME, class$java$util$Vector == null ? (class$java$util$Vector = SMGUIApplication.class$("java.util.Vector")) : class$java$util$Vector);
        acksTableModel = acksVector == null ? new ACKsTableModel() : new ACKsTableModel(acksVector);
        settings = (Settings)SMGUIApplication.load(SETTINGS_FILE_NAME, class$com$unipro$products$smgui$Settings == null ? (class$com$unipro$products$smgui$Settings = SMGUIApplication.class$("com.unipro.products.smgui.Settings")) : class$com$unipro$products$smgui$Settings);
        if (settings == null) {
            settings = new Settings();
            settings.setPortName(DEFAULT_PORT);
            settings.setPortBaud(String.valueOf(String.valueOf(DEFAULT_BAUD)).concat(""));
            settings.setSmsCenterNumber(DEFAULT_SMSC_NUMBER);
            settings.setAllowedIncomingSMS(true);
        }
    }

    public static void refreshSMSManager() throws MobileException, PortConnectionException, ValidationException {
        if (smsManager == null) {
            return;
        }
        smsManager.close();
        smsManager.init(new Configurator(settings.getPortName(), Integer.parseInt(settings.getPortBaud())));
    }

    private static void save(String fileName, Object object) {
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(object);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object load(String fileName, Class objclass) {
        Object result = null;
        FileInputStream fos = null;
        fos = new FileInputStream(fileName);
        ObjectInputStream oos = new ObjectInputStream(fos);
        result = oos.readObject();
        Object var6_6 = null;
        if (fos == null) return result;
        try {
            fos.close();
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
        {
            catch (Exception exception) {
                Object var6_7 = null;
                if (fos == null) return result;
                try {
                    fos.close();
                    return result;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return result;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (fos == null) throw throwable;
            try {
                fos.close();
                throw throwable;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            throw throwable;
        }
    }

    public static void centerFrame(Component frame) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }
}

