


import java.awt.*;
import java.io.*;
import java.net.*;

		public abstract class Pipe extends Thread {
	protected Pipe sink = null;
	protected PipedWriter out = null;
	protected PipedReader in = null;

  
	/**
	 * This constructor is for creating terminal Pipe threads--i.e. those
	 * sinks that are at the end of the pipe, and are not connected to any
	 * other threads.
	 **/
	public Pipe() { super(); }
	/**
	 * Create a Pipe and connect it to the specified Pipe 
	 **/
	public Pipe(Pipe sink) throws IOException { 
	  this.sink = sink; 
	  out = new PipedWriter();
	  out.connect(sink.getReader());
	}
	/**
	 * This protected method requests a Pipe thread to create and return
	 * a PipedReader thread so that another Pipe thread can connect to it.
	 **/
	protected PipedReader getReader() {
	  if (in == null) in = new PipedReader();
	  return in;
	}
	/** Wait for all threads in the pipe to terminate */
	public void joinPipe() throws InterruptedException { 
	  if (sink != null) sink.joinPipe(); 
	  this.join(); 
	}
	/** Call resume() on all threads in the pipe, in sink-to-source order */
	public void resumePipe() { 
	  if (sink != null)  sink.resumePipe(); 
	  this.resume(); 
	}
	/**
	 * This and the following methods provide versions of basic Thread methods
	 * that operate on the entire pipe of threads.  
	 * This one calls start() on all threads in sink-to-source order.
	 **/
	public void startPipe() { 
	  if (sink != null) sink.startPipe(); 
	  this.start(); 
	}
	/** Call stop() on all threads in the pipe, in source-to-sink order */
	public void stopPipe() { 
	  this.stop(); 
	  if (sink != null) sink.stopPipe(); 
	}
	/** Call suspend() on all threads in the pipe, in source-to-sink order */
	public void suspendPipe() { 
	  this.suspend(); 
	  if (sink != null) sink.suspendPipe();
	}
}            