package com.tolstoy.imagemeister;

import java.awt.*;

/**
The control bar at the top of ImageMeister.

<P>
When this object is created, it is passed an object implementing the ButtonPanelOwnerI interface; this object
will be called when the user clicks one of the buttons.

<P>
This object also contains the two checkboxes and the text area in which the current folder is displayed.

Copyright (c) 1998-2002 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.
*/

class ButtonPanel extends Panel implements ButtonPanelI {
	private static final String copyright="ImageMeister Copyright (c) 1998-2002 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.";

	private ImageButton				btn0, btn1, btn2, btn3, btn4;
	private ImageButtonToggle		cb1, cb2;
	private String					fileString;
	private ButtonPanelOwnerI		owner;

	private static final int		kButtonW = 64;
	private static final int		kButtonH = 16;
	private static final int		kButtonY = 5;

	private static final int		kCheckboxW = 101;
	private static final int		kCheckboxH = 16;

	private static final int		kButton1X = 10;
	private static final int		kButton2X = 10 + kButton1X + kButtonW;
	private static final int		kButton3X = 10 + kButton2X + kButtonW;
	private static final int		kButton4X = 10 + kButton3X + kButtonW;

	private static final int		kCheckbox1X = 30 + kButton4X + kButtonW;
	private static final int		kCheckbox2X = 20 + kCheckbox1X + kCheckboxW;
	
	private static final int		kLevelX = 10;
	private static final int		kLevelY = 25;
	private static final int		kLevelW = 300;
	private static final int		kLevelH = 15;

	private static final int		kUpALevelX = kLevelX + kLevelW + 20;
	private static final int		kUpALevelY = kLevelY;
	private static final int		kUpALevelW = 28;
	private static final int		kUpALevelH = 16;

/**
@param onr the object which will be called when a button is pressed
@param imBase the path to the folder containing the .gif files with the button graphics
*/

	public ButtonPanel( ButtonPanelOwnerI onr, String imBase ) {
		owner = onr;

		fileString = "";
		setLayout( null );

		btn0 = new ImageButton( imBase + "quitu.gif", imBase + "quitd.gif", kButtonW, kButtonH );
		add( btn0 );
		btn0.reshape( kButton1X, kButtonY, kButtonW, kButtonH );

		btn1 = new ImageButton( imBase + "aboutu.gif", imBase + "aboutd.gif", kButtonW, kButtonH );
		add( btn1 );
		btn1.reshape( kButton2X, kButtonY, kButtonW, kButtonH );

		btn2 = new ImageButton( imBase + "infou.gif", imBase + "infod.gif", kButtonW, kButtonH );
		add( btn2 );
		btn2.reshape( kButton3X, kButtonY, kButtonW, kButtonH );

		btn3 = new ImageButton( imBase + "showu.gif", imBase + "showd.gif", kButtonW, kButtonH );
		add( btn3 );
		btn3.reshape( kButton4X, kButtonY, kButtonW, kButtonH );

		btn4 = new ImageButton( imBase + "levelu.gif", imBase + "leveld.gif", kUpALevelW, kUpALevelH );
		add( btn4 );
		btn4.reshape( kUpALevelX, kUpALevelY, kUpALevelW, kUpALevelH );


		cb1 = new ImageButtonToggle( imBase + "cbshow0.gif", imBase + "cbshow1.gif", kCheckboxW, kCheckboxH );
		add( cb1 );
		cb1.reshape( kCheckbox1X, kButtonY, kCheckboxW, kCheckboxH );

		cb2 = new ImageButtonToggle( imBase + "cbnew0.gif", imBase + "cbnew1.gif", kCheckboxW, kCheckboxH );
		add( cb2 );
		cb2.reshape( kCheckbox2X, kButtonY, kCheckboxW, kCheckboxH );
	}

/**
From the ButtonPanelI interface.
*/

	public boolean getCheckboxValue( int which ) {
		if ( which == kCheckboxShowAllFiles )
			return cb1.getState();
		else if ( which == kCheckboxNewWindow )
			return cb2.getState();

		return false;
	}

/**
From the ButtonPanelI interface.
*/

	public void setCheckboxValue( int which, boolean b ) {
		if ( which == kCheckboxShowAllFiles )
			cb1.setState( b );
		else if ( which == kCheckboxNewWindow )
			cb2.setState( b );
	}

/**
The text area showing the current folder ("<Top Level>", etc.)
*/

	public void setFileString( String s ) {
		fileString = s;
		repaint();
	}

	public boolean handleEvent( Event e ) {
		if ( e.id == Event.ACTION_EVENT ) {
			if ( e.target == btn0 ) {
				owner.buttonClicked( ButtonPanelOwnerI.kButtonQuit );
				return true;
			}
			else if ( e.target == btn1 ) {
				owner.buttonClicked( ButtonPanelOwnerI.kButtonAbout );
				return true;
			}
			else if ( e.target == btn2 ) {
				owner.buttonClicked( ButtonPanelOwnerI.kButtonInfo );
				return true;
			}
			else if ( e.target == btn3 ) {
				owner.buttonClicked( ButtonPanelOwnerI.kButtonShow );
				return true;
			}
			else if ( e.target == btn4 ) {
				owner.buttonClicked( ButtonPanelOwnerI.kButtonUpALevel );
				return true;
			}
			else if ( e.target == cb1 ) {
				owner.buttonClicked( ButtonPanelOwnerI.kCheckboxShowAllFiles );
				return true;
			}
			else if ( e.target == cb2 ) {
				owner.buttonClicked( ButtonPanelOwnerI.kCheckboxNewWindow );
				return true;
			}
		}
		
		return super.handleEvent( e );
	}

	public void paint( Graphics g ) {
		Dimension		dd;
		
		dd = size();
		g.setColor( Color.lightGray );
		g.fillRect( 0, 0, dd.width - 1, dd.height - 1 );
		
		//g.setColor( Color.gray );
		g.fillRect( kLevelX, kLevelY, kLevelW, kLevelH );
		g.draw3DRect( kLevelX, kLevelY, kLevelW, kLevelH, true );

		g.setColor( Color.red );
		g.drawString( fileString, kLevelX + 5, kLevelY + kLevelH - 2 );
	}

	public Dimension preferredSize() {
		return new Dimension( 400, 45 );
	}
}


