/****************************************************

	JConfig Source Code Distribution
	version: 2.1.0      written: Mon May 28 10:11:26 PDT 2001

	Unless otherwise noted, all contents
	Copyright (c) 1997,1998,1999,2000 Samizdat Productions.
	All Rights Reserved.
	All contents are subject to the terms of the
	JConfig Source Code License Agreement

****************************************************/

#include "RNIUtils.h"

void RNIGetAppData( AppDataType *setDataP, struct HArrayOfInt* pAppData )
{
	setDataP->hwnd = (HWND) ( pAppData->body )[ 0 ];
	setDataP->pi.hProcess = (void*) ( pAppData->body )[ 1 ];
	setDataP->pi.hThread = (void*) ( pAppData->body )[ 2 ];
	setDataP->pi.dwProcessId = ( pAppData->body )[ 3 ];
	setDataP->pi.dwThreadId = ( pAppData->body )[ 4 ];
}

void RNISetAppData( AppDataType *appDataP, struct HArrayOfInt* pAppData )
{
	( pAppData->body )[ 0 ] = (DWORD) appDataP->hwnd;
	( pAppData->body )[ 1 ] = (DWORD) appDataP->pi.hProcess;
	( pAppData->body )[ 2 ] = (DWORD) appDataP->pi.hThread;
	( pAppData->body )[ 3 ] = appDataP->pi.dwProcessId;
	( pAppData->body )[ 4 ] = appDataP->pi.dwThreadId;
}

void RNISetIntArrayRegion( struct HArrayOfInt* pArray, long start, long numToSet, long *dataP )
{
	long			i;

	for ( i = 0; i < numToSet; i++ )
		( pArray->body )[ i + start ] = *dataP++;
}

void RNISetLongArrayRegion( struct HArrayOfLong* pArray, long start, long numToSet, __int64 *dataP )
{
	long			i;

	for ( i = 0; i < numToSet; i++ )
		( pArray->body )[ i + start ] = *dataP++;
}

void RNIGetIntArrayRegion( struct HArrayOfInt* pArray, long start, long numToSet, long *dataP )
{
	long			i;

	for ( i = 0; i < numToSet; i++ )
		*dataP++ = ( pArray->body )[ i + start ];
}

void RNIGetLongArrayRegion( struct HArrayOfLong* pArray, long start, long numToSet, __int64 *dataP )
{
	long			i;

	for ( i = 0; i < numToSet; i++ )
		*dataP++ = ( pArray->body )[ i + start ];
}



