/****************************************************

	JConfig Source Code Distribution
	version: 2.1.0      written: Mon May 28 10:11:26 PDT 2001

	Unless otherwise noted, all contents
	Copyright (c) 1997,1998,1999,2000 Samizdat Productions.
	All Rights Reserved.
	All contents are subject to the terms of the
	JConfig Source Code License Agreement

****************************************************/

#include "CStringVector.h"
#include "Debugger.h"

#if defined( DO_RNI1 ) || defined( DO_RNI2 )

CStringVector::CStringVector( long max, JOBJECTARRAY pStrs )
{
	vec = new CVector( max, max );
	initFrom( max, pStrs );
}

CStringVector::CStringVector( JOBJECTARRAY pStrs )
{
	long		max;

	max = GETINTARRAYLEN( pStrs );

	vec = new CVector( max, max );
	initFrom( max, pStrs );
}

void CStringVector::initFrom( long max, JOBJECTARRAY pStrs )
{
	JSTRING			jStr;
	CStr			*cStr;
	long			srcLen, i;
	
	if ( max < 1 )
		return;

	srcLen = GETOBJECTARRAYLEN( pStrs );
	if ( max > srcLen )
		max = srcLen;

	for ( i = 0; i < max; i++ ) {
		jStr = (JSTRING) GETSTRARRAYELEMENT( pStrs, i );
		cStr = new CStr( jStr );
		vec->append( cStr );
	}
}

void CStringVector::slamInto( JOBJECTARRAY pStrs )
{
	CStr			*csStr;
	unsigned long	i, numToCopy;

	numToCopy = getNumStrings();
	if ( numToCopy > GETOBJECTARRAYLEN( pStrs ) )
		numToCopy = GETOBJECTARRAYLEN( pStrs );

	for ( i = 0; i < numToCopy; i++ ) {
		csStr = getString( i );
		if ( csStr != NULL ) {
			SETSTRARRAYELEMENT( pStrs, i, csStr );
		}
	}
}

#elif defined( DO_JNI )

CStringVector::CStringVector( JNIEnv *pEnv, long max, JOBJECTARRAY pStrs )
{
	vec = new CVector( max, max );
	initFrom( pEnv, max, pStrs );
}

CStringVector::CStringVector( JNIEnv *pEnv, JOBJECTARRAY pStrs )
{
	long		max;

	max = GETINTARRAYLEN( pStrs );

	vec = new CVector( max, max );
	initFrom( pEnv, max, pStrs );
}

void CStringVector::initFrom( JNIEnv *pEnv, long max, JOBJECTARRAY pStrs )
{
	JSTRING			jStr;
	CStr			*cStr;
	long			srcLen, i;
	
	if ( max < 1 )
		return;

	srcLen = GETOBJECTARRAYLEN( pStrs );
	if ( max > srcLen )
		max = srcLen;

	for ( i = 0; i < max; i++ ) {
		jStr = (JSTRING) GETSTRARRAYELEMENT( pStrs, i );
		cStr = new CStr( pEnv, jStr );
		vec->append( cStr );
	}
}

void CStringVector::slamInto( JNIEnv *pEnv, JOBJECTARRAY pStrs )
{
	CStr			*csStr;
	unsigned long	i, numToCopy;

	numToCopy = getNumStrings();
	if ( numToCopy > GETOBJECTARRAYLEN( pStrs ) )
		numToCopy = GETOBJECTARRAYLEN( pStrs );

	for ( i = 0; i < numToCopy; i++ ) {
		csStr = getString( i );
		if ( csStr != NULL ) {
			SETSTRARRAYELEMENT( pStrs, i, csStr );
		}
	}
}

#endif

CStringVector::CStringVector( long max )
{
	vec = new CVector( max, max );
}

CStringVector::~CStringVector()
{
	CStr		*cs;
	long		n, i;

	n = getNumStrings();
	for ( i = 0; i < n; i++ ) {
		cs = getString( i );
		if ( cs != NULL )
			delete cs;
	}
}

void CStringVector::appendString( CStr *cs )
{
	vec->append( cs );
}

void CStringVector::removeString( CStr *cs )
{
	vec->remove( cs );
}

void CStringVector::appendPackedString( const CStr *ps )
{
	CStr		*newCStr;
	long		i, numStrs;

	numStrs = CStr::countPackedStrings( ps );
	for ( i = 0; i < numStrs; i++ ) {
		newCStr = CStr::getPackedString( ps, i );
		if ( newCStr == NULL )
			break;
		appendString( newCStr );
	}
}

CStr *CStringVector::getString( long i )
{
	CStr		*retStr;

	retStr = (CStr*) vec->elementAt( i );

	if ( retStr == NULL )
		Debugger::debug( __LINE__, _TXL( "CSV::getS NULL" ), NULL, NULL, i, 0 );

	return retStr;
}

long CStringVector::getNumStrings()
{
	return vec->getSize();
}

void CStringVector::setString( CStr *cs, long i )
{
	CStr		*deleteCS;

	if ( i < 0 || i >= getNumStrings() )
		return;

	deleteCS = getString( i );
	if ( deleteCS != NULL )
		delete deleteCS;
	
	vec->setAt( i, cs );
}

BOOL CStringVector::contains( const CStr *cs )
{
	CStr		*csTemp;
	long		num, i;

	num = getNumStrings();
	if ( num < 1 )
		return FALSE;

	for ( i = 0; i < num; i++ ) {
		csTemp = getString( i );
		if ( cs->isEqual( csTemp ) )
			return TRUE;
	}

	return FALSE;
}

BOOL CStringVector::containsIgnoreCase( const CStr *cs )
{
	CStr		*csTemp;
	long		num, i;

	num = getNumStrings();
	if ( num < 1 )
		return FALSE;

	for ( i = 0; i < num; i++ ) {
		csTemp = getString( i );
		if ( cs->isEqualIgnoreCase( csTemp ) )
			return TRUE;
	}

	return FALSE;
}

void CStringVector::dumpInfo()
{
	long			i;

	Debugger::debug( 0, _TXL( "for vector:" ), NULL, NULL, getNumStrings(), (long) this );

	for ( i = 0; i < getNumStrings(); i++ )
		Debugger::debug( 0, _TXL( "    at " ), (CStr*) vec->elementAt( i ), NULL, i, 0 );
}

