/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.util.Vector;

class GubshellGUI
extends Frame
implements ActionListener {
    private AboutGubshell aboutGubshell;
    private MenuBar menubar;
    private Menu file;
    private MenuItem quit;
    private Menu help;
    private MenuItem about;
    Choice clientMenu;
    private CheckboxGroup target;
    private Checkbox namedFrame;
    private TextField frameName;
    private Checkbox newWindow;
    private Checkbox currentFrame;
    private Checkbox parentFrame;
    private Checkbox topFrame;
    private TextField url;
    private Button push;
    private Label errmsg;
    private Vector clients;
    private DataOutputStream outstream;

    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (cmd.equals("quit")) {
            System.exit(0);
        }
        if (cmd.equals("about")) {
            this.aboutGubshell.show();
        }
    }

    private void showErrmsg(String text) {
        this.errmsg.setText(text);
        this.errmsg.invalidate();
        this.validate();
    }

    private void constructGUI() {
        this.setTitle("Gubshell");
        this.setLayout(new GridLayout(9, 1));
        this.aboutGubshell = new AboutGubshell();
        this.menubar = new MenuBar();
        this.setMenuBar(this.menubar);
        this.target = new CheckboxGroup();
        this.file = new Menu("File");
        this.menubar.add(this.file);
        this.quit = new MenuItem("Quit", new MenuShortcut(81));
        this.quit.addActionListener(this);
        this.quit.setActionCommand("quit");
        this.file.add(this.quit);
        this.help = new Menu("Help");
        this.menubar.add(this.help);
        this.menubar.setHelpMenu(this.help);
        this.about = new MenuItem("About", new MenuShortcut(65));
        this.about.addActionListener(this);
        this.about.setActionCommand("about");
        this.help.add(this.about);
        Panel panel = new Panel(new FlowLayout(0));
        this.add(panel);
        panel.add(new Label("Client: "));
        this.clientMenu = new Choice();
        panel.add(this.clientMenu);
        panel = new Panel(new FlowLayout(0));
        this.add(panel);
        this.namedFrame = new Checkbox("Send to frame named....", this.target, true);
        panel.add(this.namedFrame);
        this.frameName = new TextField(40);
        panel.add(this.frameName);
        panel = new Panel(new FlowLayout(0));
        this.add(panel);
        this.newWindow = new Checkbox("Send to new window.", this.target, false);
        panel.add(this.newWindow);
        panel = new Panel(new FlowLayout(0));
        this.add(panel);
        this.currentFrame = new Checkbox("Replace current frame.", this.target, false);
        panel.add(this.currentFrame);
        panel = new Panel(new FlowLayout(0));
        this.add(panel);
        this.parentFrame = new Checkbox("Replace parent frame.", this.target, false);
        panel.add(this.parentFrame);
        panel = new Panel(new FlowLayout(0));
        this.add(panel);
        this.topFrame = new Checkbox("Replace entire page.", this.target, false);
        panel.add(this.topFrame);
        panel = new Panel(new FlowLayout(0));
        this.add(panel);
        panel.add(new Label("URL: "));
        this.url = new TextField(80);
        panel.add(this.url);
        panel = new Panel(new FlowLayout(1));
        this.add(panel);
        this.push = new Button("Push content");
        panel.add(this.push);
        this.push.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String urlText = GubshellGUI.this.url.getText();
                if (urlText == null || urlText.length() < 1) {
                    GubshellGUI.this.showErrmsg("Please enter URL of content.");
                    return;
                }
                if (!urlText.startsWith("http")) {
                    urlText = "http://" + urlText;
                }
                if (GubshellGUI.this.clientMenu.getItemCount() == 0) {
                    GubshellGUI.this.showErrmsg("No clients available to push to.");
                    return;
                }
                int clientIndex = GubshellGUI.this.clientMenu.getSelectedIndex();
                Testclient client = (Testclient)GubshellGUI.this.clients.get(clientIndex);
                Checkbox selectedTarget = GubshellGUI.this.target.getSelectedCheckbox();
                String targetName = selectedTarget == GubshellGUI.this.newWindow ? "_blank" : (selectedTarget == GubshellGUI.this.currentFrame ? "_self" : (selectedTarget == GubshellGUI.this.parentFrame ? "_parent" : (selectedTarget == GubshellGUI.this.topFrame ? "_top" : GubshellGUI.this.frameName.getText())));
                if (targetName == null || targetName.length() < 1) {
                    GubshellGUI.this.showErrmsg("Please enter name of frame.");
                    return;
                }
                try {
                    String addressName = client.host.getHostAddress();
                    GubshellGUI.this.outstream.writeInt(addressName.length());
                    GubshellGUI.this.outstream.writeBytes(addressName);
                    GubshellGUI.this.outstream.writeInt(client.portNbr);
                    GubshellGUI.this.outstream.writeInt(targetName.length());
                    GubshellGUI.this.outstream.writeBytes(targetName);
                    GubshellGUI.this.outstream.writeInt(urlText.length());
                    GubshellGUI.this.outstream.writeBytes(urlText);
                }
                catch (NoRouteToHostException x1) {
                    GubshellGUI.this.showErrmsg("Client is not net-reachable.");
                    return;
                }
                catch (ConnectException x2) {
                    GubshellGUI.this.showErrmsg("Cannot connect to client.");
                    return;
                }
                catch (IOException x3) {
                    GubshellGUI.this.showErrmsg("I/O error contacting client.");
                    return;
                }
            }
        });
        panel = new Panel(new FlowLayout(0));
        this.add(panel);
        this.errmsg = new Label("");
        panel.add(this.errmsg);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        this.pack();
    }

    GubshellGUI(DataOutputStream outstream, Vector clients) {
        super("Gubshell");
        this.outstream = outstream;
        this.clients = clients;
        this.constructGUI();
    }
}

