/*Data Access Library. v. 1.1.
 *Class descriptor. Support class for code generation.
 *AUTHOR:  Alexander Jaremenko <jarem@altavista.net>
 *RELEASE DATE: 
 */

package JProjects.eab.data.wizzard;

class ClassDescriptor {
    private String baseName;
    private String pkgName;
    private boolean readOnly;
    private boolean dataId = false;

    ClassDescriptor() {
	this(null,true,true);
    }

    ClassDescriptor(String clName,boolean isRead,boolean aDataId) {
	if (clName != null) {
	    baseName = base(clName);
	    pkgName = packName(clName);
	}
	readOnly = isRead;
	dataId = aDataId;
    }

    void setBaseName(String aName) {
	baseName = base(aName);
	pkgName = packName(aName);
    }

    void setReadOnly(boolean flag) {
	readOnly = flag;
    }

    void setDataId(boolean flag) {
	dataId = flag;
    }

    boolean hasDataId() {
	return dataId;
    }

    boolean isReadOnly() {
	return readOnly;
    }

    String getBaseName() {
	return baseName;
    }

    String getPkgName() {
	return pkgName;
    }

    String getDataIdName() {
	return baseName+"DataId";
    }

    String getPOName() {
	return baseName;
    }

    String getPOManagerName() {
	return baseName+"Manager";
    }

    String getPODatastoreName() {
	return "i"+baseName+"Datastore";
    }

    String getDataIdManagerName() {
	return baseName+"DataIdManager";
    }

    String getPOMapName() {
	return baseName+"Map";
    }

    String getDataIdMapName() {
	return baseName+"DataIdMap";
    }

    private String base(String aName) {
	int idx = aName.indexOf('.');
	String res = aName;
	if (idx>=0) 
	    res = res.substring(res.lastIndexOf((int)'.')+1);
	return res;
    }
    
    private String packName(String aName) {
	String res = null;
	if (aName.indexOf((int)'.')>=0)
	    res = aName.substring(0,aName.lastIndexOf((int)'.'));
	return res;
    }

}
