/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.plaf.skin.PngUtils;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import com.l2fprod.util.AccessUtils;
import com.l2fprod.util.ImageUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class SkinUtils {
    public static final boolean DEBUG = "true".equals(AccessUtils.getProperty("debug.skinlf"));

    public static void setFont(Font f) {
        UIDefaults defs = UIManager.getDefaults();
        Enumeration keys = defs.keys();
        while (keys.hasMoreElements()) {
            String aKey;
            Object o = keys.nextElement();
            if (!(o instanceof String) || !(aKey = (String)o).endsWith(".font") && !aKey.endsWith(".titleFont") && !aKey.endsWith(".acceleratorFont") || !(defs.get(aKey) instanceof FontUIResource)) continue;
            UIManager.put(aKey, f);
        }
    }

    public static Font getFont(String name, int type, int size) {
        return new Font(name, type, size);
    }

    public static Image loadImage(String filename) throws Exception {
        return SkinUtils.loadImage(SkinUtils.toURL(new File(filename)));
    }

    public static Image loadImage(URL url) throws Exception {
        Image img = null;
        if (url.toString().toLowerCase().endsWith(".png")) {
            InputStream input = SkinLookAndFeel.getInputStream(url);
            img = PngUtils.loadImage(input);
        } else {
            byte[] data = SkinLookAndFeel.getURLContent(url);
            img = Toolkit.getDefaultToolkit().createImage(data);
        }
        return ImageUtils.transparent(img);
    }

    public static URL toURL(File f) throws MalformedURLException {
        String path = f.getAbsolutePath();
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/") && f.isDirectory()) {
            path = path + "/";
        }
        return new URL("file", "", path);
    }

    public static Component findComponentAt(Container container, int x, int y) {
        if (!container.contains(x, y)) {
            return null;
        }
        int ncomponents = container.getComponentCount();
        Component[] component = container.getComponents();
        int i = 0;
        while (i < ncomponents) {
            Component comp = component[i];
            if (comp != null) {
                Point p = comp.getLocation();
                if ((comp = comp instanceof Container ? SkinUtils.findComponentAt((Container)comp, x - p.x, y - p.y) : comp.locate(x - p.x, y - p.y)) != null && comp.isVisible()) {
                    return comp;
                }
            }
            ++i;
        }
        return container;
    }

    public static String decodeColor(String color) {
        if (color.startsWith("#")) {
            return color;
        }
        StringTokenizer token = new StringTokenizer(color, ", {}");
        String result = "#";
        String r = token.nextToken();
        String g = token.nextToken();
        String b = token.nextToken();
        if (SkinUtils.is0to1color(r) && SkinUtils.is0to1color(g) && SkinUtils.is0to1color(b)) {
            r = (int)(Float.parseFloat(r) * 255.0f) + "";
            g = (int)(Float.parseFloat(g) * 255.0f) + "";
            b = (int)(Float.parseFloat(b) * 255.0f) + "";
        } else {
            r = (int)Float.parseFloat(r) + "";
            g = (int)Float.parseFloat(g) + "";
            b = (int)Float.parseFloat(b) + "";
        }
        result = result + SkinUtils.toHexString(Integer.parseInt(r));
        result = result + SkinUtils.toHexString(Integer.parseInt(g));
        result = result + SkinUtils.toHexString(Integer.parseInt(b));
        return result;
    }

    static boolean is0to1color(String composite) {
        int index = composite.indexOf(".");
        return index != -1 && composite.substring(0, index).length() <= 1;
    }

    static String toHexString(int i) {
        if (i == 0) {
            return "00";
        }
        return Integer.toHexString(i).toUpperCase();
    }
}

