/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinArrowButton;
import com.l2fprod.gui.plaf.skin.SkinComboBoxRenderer;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;

public class SkinComboBoxUI
extends BasicComboBoxUI {
    protected PropertyChangeListener editableChangeListener;
    private Skin skin = SkinLookAndFeel.getSkin();

    public Dimension getPreferredSize(JComponent c) {
        Dimension prefs = super.getMinimumSize(c);
        Dimension combo = this.skin.getPersonality().getComboBoxPreferredSize(this.comboBox);
        prefs.width = Math.max(prefs.width, combo.width);
        prefs.height = Math.max(prefs.height, combo.height);
        return prefs;
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public void paint(Graphics g, JComponent c) {
        this.hasFocus = this.comboBox.hasFocus();
        if (this.comboBox.getRenderer() instanceof SkinComboBoxRenderer) {
            if (!this.comboBox.isEditable()) {
                Rectangle r = this.rectangleForCurrentValue();
                this.skin.getPersonality().paintComboBox(g, this.comboBox, r, this.hasFocus);
                this.paintCurrentValue(g, r, false);
            } else {
                g.setColor(Color.black);
                g.drawRect(0, 0, this.comboBox.getWidth(), this.comboBox.getHeight());
            }
        } else {
            super.paint(g, c);
        }
    }

    protected Insets getInsets() {
        return this.skin.getPersonality().getComboBoxInsets();
    }

    protected JButton createArrowButton() {
        return new SkinArrowButton(5);
    }

    protected void installComponents() {
        super.installComponents();
        this.arrowButton.setVisible(this.comboBox.isEditable());
    }

    protected void installListeners() {
        super.installListeners();
        this.editableChangeListener = this.createEditableChangeListener();
        if (this.editableChangeListener != null) {
            this.comboBox.addPropertyChangeListener(this.editableChangeListener);
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.comboBox.removePropertyChangeListener(this.editableChangeListener);
        this.editableChangeListener = null;
    }

    protected Rectangle rectangleForCurrentValue() {
        int width = this.comboBox.getWidth();
        int height = this.comboBox.getHeight();
        Insets insets = this.getInsets();
        int buttonSize = 0;
        if (this.arrowButton != null && this.arrowButton.isVisible()) {
            buttonSize = this.arrowButton.getWidth();
        }
        return new Rectangle(insets.left, insets.top, width - (insets.left + insets.right + buttonSize), height - (insets.top + insets.bottom));
    }

    protected LayoutManager createLayoutManager() {
        return new SkinComboBoxLayoutManager();
    }

    protected ListCellRenderer createRenderer() {
        return new SkinComboBoxRenderer();
    }

    protected PropertyChangeListener createEditableChangeListener() {
        return new EditableChangeHandler();
    }

    protected JButton arrowButton() {
        return this.arrowButton;
    }

    protected JComboBox comboBox() {
        return this.comboBox;
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ActionListener downAction = new ActionListener(this){
            private final /* synthetic */ SkinComboBoxUI this$0;

            public final void actionPerformed(ActionEvent e) {
                if (this.this$0.comboBox().isEnabled()) {
                    if (this.this$0.isPopupVisible()) {
                        SkinComboBoxUI.access$0(this.this$0);
                    } else {
                        this.this$0.setPopupVisible(this.this$0.comboBox(), true);
                    }
                }
            }
            {
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(SkinComboBoxUI skinComboBoxUI) {
            }
        };
        this.comboBox.registerKeyboardAction(downAction, KeyStroke.getKeyStroke(40, 0), 1);
        this.comboBox.registerKeyboardAction(downAction, KeyStroke.getKeyStroke("KP_DOWN"), 1);
        ActionListener altAction = new ActionListener(this){
            private final /* synthetic */ SkinComboBoxUI this$0;

            public final void actionPerformed(ActionEvent e) {
                if (this.this$0.comboBox().isEnabled() && this.this$0.isPopupVisible()) {
                    this.this$0.togglePopup();
                }
            }
            {
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(SkinComboBoxUI skinComboBoxUI) {
            }
        };
        this.comboBox.registerKeyboardAction(altAction, KeyStroke.getKeyStroke(40, 8), 1);
        this.comboBox.registerKeyboardAction(altAction, KeyStroke.getKeyStroke("alt KP_DOWN"), 1);
        this.comboBox.registerKeyboardAction(altAction, KeyStroke.getKeyStroke(38, 8), 1);
        this.comboBox.registerKeyboardAction(altAction, KeyStroke.getKeyStroke("alt KP_UP"), 1);
        ActionListener upAction = new ActionListener(this){
            private final /* synthetic */ SkinComboBoxUI this$0;

            public final void actionPerformed(ActionEvent e) {
                if (this.this$0.comboBox().isEnabled() && this.this$0.isPopupVisible()) {
                    SkinComboBoxUI.access$1(this.this$0);
                }
            }
            {
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(SkinComboBoxUI skinComboBoxUI) {
            }
        };
        this.comboBox.registerKeyboardAction(upAction, KeyStroke.getKeyStroke(38, 0), 1);
        this.comboBox.registerKeyboardAction(upAction, KeyStroke.getKeyStroke("KP_UP"), 1);
    }

    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 0));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke("KP_DOWN"));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 8));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke("alt KP_DOWN"));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, 0));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke("KP_UP"));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, 8));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke("alt KP_UP"));
    }

    protected Component editor() {
        return this.editor;
    }

    boolean isPopupVisible() {
        return super.isPopupVisible(this.comboBox);
    }

    void togglePopup() {
        this.toggleOpenClose();
    }

    public static ComponentUI createUI(JComponent c) {
        return new SkinComboBoxUI();
    }

    static /* synthetic */ void access$0(SkinComboBoxUI skinComboBoxUI) {
        super.selectNextPossibleValue();
    }

    static /* synthetic */ void access$1(SkinComboBoxUI skinComboBoxUI) {
        super.selectPreviousPossibleValue();
    }

    public class EditableChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName.equals("renderer")) {
                if (!(e.getNewValue() instanceof SkinComboBoxRenderer)) {
                    SkinComboBoxUI.this.arrowButton().setVisible(true);
                } else {
                    SkinComboBoxUI.this.arrowButton().setVisible(SkinComboBoxUI.this.comboBox.isEditable());
                }
            } else if (propertyName.equals("editable")) {
                SkinComboBoxUI.this.arrowButton().setVisible((Boolean)e.getNewValue());
                SkinComboBoxUI.this.comboBox().revalidate();
                SkinComboBoxUI.this.comboBox().repaint();
            }
        }
    }

    public class SkinComboBoxLayoutManager
    implements LayoutManager {
        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return parent.getPreferredSize();
        }

        public Dimension minimumLayoutSize(Container parent) {
            return parent.getMinimumSize();
        }

        public void layoutContainer(Container parent) {
            JComboBox cb = (JComboBox)parent;
            int width = cb.getWidth();
            int height = cb.getHeight();
            Insets insets = cb.getInsets();
            int buttonSize = height - (insets.top + insets.bottom);
            if (SkinComboBoxUI.this.arrowButton() != null && SkinComboBoxUI.this.arrowButton().isVisible()) {
                SkinComboBoxUI.this.arrowButton().setBounds(width - (insets.right + buttonSize), insets.top, buttonSize, buttonSize);
            }
            if (SkinComboBoxUI.this.editor() != null) {
                Rectangle cvb = SkinComboBoxUI.this.rectangleForCurrentValue();
                SkinComboBoxUI.this.editor().setBounds(cvb);
            }
        }
    }
}

