/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.ftp;

import java.io.File;
import java.io.IOException;
import javax.swing.filechooser.FileSystemView;
import photoorganizer.ftp.Ftp;
import photoorganizer.ftp.FtpFile;

public class FtpFileSystemView
extends FileSystemView {
    private Ftp ftp;

    public FtpFileSystemView(Ftp ftp) {
        this.ftp = ftp;
    }

    public File createFileObject(File file, String string) {
        return new FtpFile(this.ftp, file.getPath(), string);
    }

    public File createFileObject(String string) {
        return new FtpFile(this.ftp, string);
    }

    public boolean isRoot(File file) {
        return file instanceof FtpFile && file.getParent() == null && file.getName().length() == 0;
    }

    public File createNewFolder(File file) throws IOException {
        FtpFile ftpFile = new FtpFile(this.ftp, file.getPath() + "/NewFolder");
        if (ftpFile.mkdir()) {
            return ftpFile;
        }
        return null;
    }

    public File[] getRoots() {
        return new File[]{new FtpFile(this.ftp, "/")};
    }

    public boolean isHiddenFile(File file) {
        if (file instanceof FtpFile) {
            return ((FtpFile)file).isHidden();
        }
        return false;
    }

    public File getParentDirectory(File file) {
        String string = file.getParent();
        if (string == null) {
            return null;
        }
        return new FtpFile(this.ftp, string);
    }

    public File[] getFiles(File file, boolean bl) {
        if (file instanceof FtpFile) {
            return ((FtpFile)file).listFiles();
        }
        return new FtpFile(this.ftp, file.getPath()).listFiles();
    }

    public File getHomeDirectory() {
        return new FtpFile(this.ftp, this.ftp.getHomeDirectory());
    }
}

