// Win3DZView.h : interface of the CWin3DZView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_WIN3DZVIEW_H__887E824F_8BDA_11D3_B5BA_AD3FC7D8670A__INCLUDED_)
#define AFX_WIN3DZVIEW_H__887E824F_8BDA_11D3_B5BA_AD3FC7D8670A__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class CWin3DZView : public CView
{
protected: // create from serialization only
	CWin3DZView();
	DECLARE_DYNCREATE(CWin3DZView)

// Attributes
public:
	CWin3DZDoc* GetDocument();

	// plot variables
	int		m_abort_plotting;// 0=no, 1=abort plotting
	BOOL	m_is_drawn;	// 0=no, 1=plot has been drawn (used for redraw via plot file)
	CString	m_fn_cap;	// pen movement capture file (each view gets it's own file)
	CString	m_fn_input;	// filename for input file (if any)
	CRect	m_plot_rect;// plot rectangle

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CWin3DZView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual void OnPrepareDC(CDC* pDC, CPrintInfo* pInfo = NULL);
	protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrintPreview(CDC* pDC, CPrintInfo* pInfo, POINT point, CPreviewView* pView);
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CWin3DZView();

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CWin3DZView)
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnEditCopy();
	afx_msg void OnHelpGettingstarted();
	afx_msg void OnHelpIntroduction();
	afx_msg void OnHelpTips();
	afx_msg void OnResizeWindow();
	afx_msg void OnDrawPlot();
	afx_msg void OnHelpHiddenlineremoval();
	afx_msg void OnHelpPlotparameters();
	afx_msg void OnHelpCprogramming();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in Win3DZView.cpp
inline CWin3DZDoc* CWin3DZView::GetDocument()
   { return (CWin3DZDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_WIN3DZVIEW_H__887E824F_8BDA_11D3_B5BA_AD3FC7D8670A__INCLUDED_)
