// testlbl.cpp - Tests RtPlot by adding line-by-line
#include <stdlib.h>
#include <io.h>
#include <fcntl.h>
#include <stdio.h>
#include <math.h>
#include <assert.h>
#include <windows.h>

void
print_plot(const char *fname, double xstart, double dx,
	   long int sleep, const double XMAX )
{
  double x = -dx;
  FILE *f = fopen(fname, "w");
  // Obtain file handle from the OS corresponding to 
  // file pointer f
  HANDLE h = (HANDLE) (_get_osfhandle(_fileno(f) ));
  while(1) {
    //for( int i = 0; i < N; ++i ) {
    x += dx;
    if( x > XMAX ) break;
    double ysin = sin(x);
    double ycos = cos(x);
    fprintf(f, "%8.3f %8.3f %8.3f", x, ysin, ycos);
    fprintf(f, "\n");
    fflush(f);
    // Force system to update write time of file
    // so that RtPlot display will be updated
    FILETIME write_time;
    ::GetSystemTimeAsFileTime(&write_time);
    ::SetFileTime(h, NULL, NULL, &write_time);
    // Sleep for a while
    ::Sleep(sleep);
  }
  fclose(f);
  return;
}

int main(int argc, char **argv)
{
  const double XMAX = 20.0;
  const double dx = (2*acos(-1))/64;
  while(1) {
    print_plot("testplot.txt", 0.0, dx, 1000L, XMAX ); 
  }
  return 0;
}
