//----------------------------------------------------------
#ifndef FrmDesgnH
#define FrmDesgnH
#include <vcl\ComCtrls.hpp>
#include <vcl\Controls.hpp>
#include <vcl\Classes.hpp>
#include <vcl\ExtCtrls.hpp>
#include <vcl\Menus.hpp>
#include <vcl\Dialogs.hpp>
#include <vcl\StdCtrls.hpp>
#include "D3dVCs.h"
#include "D3dMove.h"
#include <vcl\Buttons.hpp>
//----------------------------------------------------------
HRESULT OnTextureLoad
    (char *name, void *arg, LPDIRECT3DRMTEXTURE *ITex);
//----------------------------------------------------------
const int XS_FRAME         = 1;
const int XS_BUILDER       = 2;
const int XS_TEXTURE       = 3;
const int XS_AMBIENT       = 4;
const int XS_SPOT          = 5;
const int XS_POINT         = 6;
const int XS_DIRECTIONAL   = 7;
const int XS_PARALLELPOINT = 8;
//----------------------------------------------------------
void SetImIx(TTreeNode *N, int i);
void SetLightImage(TTreeNode *N);
//----------------------------------------------------------
class TDesignForm : public TForm
{
__published:  // IDE-managed Components
  TMainMenu *Menu;
  TMenuItem *FileItem;
  TMenuItem *cmdFileNew;
  TMenuItem *N1;
  TMenuItem *cmdFileExit;
  TOpenDialog *OpenDlg;
  TSaveDialog *SaveDlg;
  TStatusBar *StatBar;
  TMenuItem *ViewItem;
  TTreeView *Tree;
  TImageList *TreeImages;
  TMenuItem *EditItem;
  TMenuItem *cmdCut;
  TMenuItem *cmdCopy;
  TMenuItem *cmdPasteCopy;
  TMenuItem *NewItem;
  TMenuItem *cmdNewFrame;
  TMenuItem *LightItem;
  TMenuItem *cmdLookFrom;
  TMenuItem *OptionsItem;
  TMenuItem *cmdDirect3D;
  TMenuItem *cmdDelete;
  TMenuItem *cmdLookAt;
  TMenuItem *cmdAmbient;
  TMenuItem *cmdPoint;
  TMenuItem *cmdSpot;
  TMenuItem *cmdDirectional;
  TMenuItem *cmdParallelpoint;
  TPopupMenu *TreePopup;
  TMenuItem *Expand;
  TMenuItem *Collapse;
  TMenuItem *N2;
  TMenuItem *OpenItem;
  TMenuItem *cmdOpenMesh;
  TMenuItem *cmdOpenFrame;
  TMenuItem *cmdOpenScene;
  TMenuItem *SaveItem;
  TMenuItem *cmdSaveMesh;
  TMenuItem *cmdSaveScene;
  TMenuItem *cmdSaveSceneAs;
  TMenuItem *Level1;
  TMenuItem *Level3;
  TMenuItem *cmdSaveFrame;
  TColorDialog *ColorDlg;
  TPanel *paSplit;
  TMenuItem *N3;
  TMenuItem *Level2;
  TMenuItem *Level4;
  TMenuItem *Level5;
  TMenuItem *cmdOpenTexture;
  TMenuItem *TreeItem;
  TMenuItem *cmdCollapse;
  TMenuItem *cmdExpand;
  TMenuItem *cmdFindSelected;
  TMenuItem *cmdRebuildTree;
  TMenuItem *cmdPos;
  TMenuItem *cmdNeg;
  TMenuItem *cmdBackColor;
  TMenuItem *Tools1;
  TMenuItem *cmdTexture;
  TMenuItem *cmdMaterial;
  TMenuItem *cmdColor;
  TMenuItem *cmdPasteRef;
  TPanel *paTransform;
  TSpeedButton *sbScalexMul;
  TSpeedButton *sbScalexDiv;
  TSpeedButton *sbScaleyMul;
  TSpeedButton *sbScaleyDiv;
  TSpeedButton *sbScalezMul;
  TSpeedButton *sbScalezDiv;
  TSpeedButton *sbScaleAllMul;
  TSpeedButton *sbScaleAllDiv;
  TSpeedButton *sbPosxPlus;
  TSpeedButton *sbPosxMinus;
  TSpeedButton *sbPosyPlus;
  TSpeedButton *sbPosyMinus;
  TSpeedButton *sbPoszPlus;
  TSpeedButton *sbPoszMinus;
  TSpeedButton *sbRotxPlus;
  TSpeedButton *sbRotxMinus;
  TSpeedButton *sbRotyPlus;
  TSpeedButton *sbRotyMinus;
  TSpeedButton *sbRotzPlus;
  TSpeedButton *sbRotzMinus;
  TSpeedButton *sbFromCamera;
  TEdit *edPos;
  TStatusBar *BoxStat;
  TEdit *edScale;
  TEdit *edRot;
  TMenuItem *cmdPosX;
  TMenuItem *cmdPosY;
  TMenuItem *cmdPosZ;
  TMenuItem *cmdNegX;
  TMenuItem *cmdNegY;
  TMenuItem *cmdNegZ;
  TMenuItem *N4;
  TMenuItem *cmdSceneAmbient;
  TMenuItem *cmdWrap;
  TEdit *edCameraStep;
   TCheckBox *Manip;
   TSpeedButton *sbReset;
  TMenuItem *Help1;
  TMenuItem *Contents1;
  TMenuItem *About1;
  void __fastcall cmdFileExitClick(TObject *Sender);
  void __fastcall TreeEdited(TObject *Sender, TTreeNode *Node, AnsiString &S);
  void __fastcall cmdDeleteClick(TObject *Sender);
  void __fastcall cmdFileNewClick(TObject *Sender);
  void __fastcall TreeChange(TObject *Sender, TTreeNode *Node);
  void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
  void __fastcall cmdNewFrameClick(TObject *Sender);
  void __fastcall cmdLookAtClick(TObject *Sender);
  void __fastcall cmdSaveSceneClick(TObject *Sender);
  void __fastcall cmdSaveSceneAsClick(TObject *Sender);
  void __fastcall cmdLookFromClick(TObject *Sender);
  void __fastcall CollapseClick(TObject *Sender);
  void __fastcall ExpandClick(TObject *Sender);
  void __fastcall cmdOpenMeshClick(TObject *Sender);
  void __fastcall cmdOpenFrameClick(TObject *Sender);
  void __fastcall cmdSaveMeshClick(TObject *Sender);
  void __fastcall Level1Click(TObject *Sender);
  void __fastcall cmdSaveFrameClick(TObject *Sender);
  void __fastcall cmdColorClick(TObject *Sender);
  void __fastcall paSplitMouseUp(TObject *Sender, TMouseButton Button,
  TShiftState Shift, int X, int Y);
  void __fastcall cmdCutClick(TObject *Sender);
  void __fastcall TreeDragDrop(TObject *Sender, TObject *Source, int X, int Y);
  void __fastcall TreeGetImageIndex(TObject *Sender, TTreeNode *Node);
  void __fastcall cmdCopyClick(TObject *Sender);
  void __fastcall TreeDragOver(TObject *Sender, TObject *Source, int X, int Y,
  TDragState State, bool &Accept);
  void __fastcall TreeStartDrag(TObject *Sender, TDragObject *&DragObject);
  void __fastcall TreeEndDrag(TObject *Sender, TObject *Target, int X, int Y);
  void __fastcall RebuildTree(TObject *Sender);
  void __fastcall FindSelected(TObject *Sender);
  void __fastcall cmdDirect3DClick(TObject *Sender);
  void __fastcall FormResize(TObject *Sender);
  void __fastcall TreeMouseDown(TObject *Sender, TMouseButton Button,
  TShiftState Shift, int X, int Y);
  void __fastcall cmdMaterialClick(TObject *Sender);
  void __fastcall cmdTextureClick(TObject *Sender);
  void __fastcall cmdOpenTextureClick(TObject *Sender);
  void __fastcall TreeEditing(TObject *Sender,
  TTreeNode *Node, bool &AllowEdit);
  void __fastcall cmdOpenSceneClick(TObject *Sender);
  void __fastcall cmdAboutClick(TObject *Sender);
  void __fastcall cmdBackColorClick(TObject *Sender);
  void __fastcall NewLightClick(TObject *Sender);
  void __fastcall cmdPasteCopyClick(TObject *Sender);
  void __fastcall cmdPasteRefClick(TObject *Sender);
  void __fastcall ScaleClick(TObject *Sender);
  void __fastcall PositionClick(TObject *Sender);
  void __fastcall sbFromCameraClick(TObject *Sender);
  void __fastcall RotateClick(TObject *Sender);
  void __fastcall Projection(TObject *Sender);
  void __fastcall cmdSceneAmbientClick(TObject *Sender);
  void __fastcall cmdWrapClick(TObject *Sender);
  void __fastcall edCameraStepExit(TObject *Sender);
  void __fastcall FormCloseQuery(TObject *Sender,
  bool &CanClose);
   void __fastcall sbResetClick(TObject *Sender);
  void __fastcall Contents1Click(TObject *Sender);
private:  // User declarations
  void __fastcall VportMouseDown(TObject *Sender, TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall VportMouseMove(TObject *Sender, TShiftState Shift, int X, int Y);

  HRESULT hr;
  bool Modified, CutMode, CloneMode;
  int lastX, lastY, TreeMaxWidth;
  TMouseButton FButton;
  AnsiString CurrFileName;
  TTreeNode *CurrNode, *ClipboardNode;
  TD3dView *D3dView;
  TVport *Vport;
  TSampleStepCtrl *Ctrl;
  LPDIRECT3DRMFRAME IScene, ISelFrame;
  LPDIRECT3DRMFACE  ISelFace, ILastSelFace;
  LPDIRECT3DRMMESHBUILDER ISelBuilder, ILastSelBuilder;
  LPDIRECT3DRMTEXTURE ISelTexture;
  DWORD SelVertex, LastSelVertex;
  D3DVECTOR SelVertexPos;
  void __fastcall ViewSelect(int X, int Y);
  void __fastcall SelectVertex(int X, int Y);
  TTreeNode* __fastcall CurrentFrameNode();
  void __fastcall AssociativeDelete(TTreeNode* Node);
  void __fastcall FrameToTree(LPDIRECT3DRMFRAME Iframe);
  void __fastcall FrameToTreeRecursion(LPDIRECT3DRMFRAME Iframe);
  void __fastcall PasteCut();
  void __fastcall PasteCopied();
  void __fastcall Save(AnsiString& FileName);
  void __fastcall Changed();
  void __fastcall EditorState(AnsiString& FileName, bool modified);
  void __fastcall DrawCurrentCS();
  void __fastcall DrawSelections();
  void __fastcall UpdateTools(TObject *Sender);
  void __fastcall CheckSave();
public:   // User declarations
  LPDIRECT3DRM  IRM; // public  OnTextureLoad
  __fastcall TDesignForm(TComponent* Owner);
  void __fastcall Update() {
     //     :
     D3dView->Render();
     //   :
     Changed();
  }
};
//----------------------------------------------------------
extern TDesignForm *DesignForm;
//----------------------------------------------------------
#endif
