//
//
//                                                           %__________%
//                                                          %/ . .  .   \%
//           Van Gogh 2D-Display Library                     |  . .  o. |
//                                                           |. _  .   .|
//        Microsoft Windows 95/98/NT Version                 | / \   .  |
//                                                           |_|_|_._._.|
//                                                           |.-.-.-.-..|
//                                                          %\__________/%
//                                                           %          %
//
//  Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Dan Higdon & Chuck Walbourn
//
// bezier.cpp
//
// This is a simple bezier support module.  See the header file for
// interface details.
//
//

#ifndef __BEZIER_H
#define __BEZIER_H  1

//
//
//                                Classes
//
//

// This is a class used to simulate function closures for the
// draw_bezier function.  A BezierAction to draw the curve
// is provided below.  One to plot the points in color
// space is possible as well.
// (Think of this as a function pointer from which you can derive
//  a new function context)
struct BezierClosure
{
virtual void operator () (int x, int y) = 0;
};

//
//
//                               Prototypes
//
//

// Find the midpoint
inline POINT midpoint (POINT a, POINT b)
{
        POINT res;

        res.x = int ((float(a.x + b.x) / 2.0) + 0.5);
        res.y = int ((float (a.y + b.y) / 2.0) + 0.5);

        return res;
}

// Compare two points.
inline int operator == (POINT p1, POINT p2)
{
        return abs (p1.x - p2.x) <= 1 && abs (p1.y - p2.y) <= 1;
}

// The API call for beziers.  What it does is call
// the closure with every point along the bezier curve
// described by the parameter points.
void bezier (BezierClosure &func, POINT pts[4]);

#endif

// eof - bezier.h 

