//
//
//
//
//
//
//
//
//
//
// Microsoft Windows 95/98/NT Version 
//
//Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Tim Little & Chuck Walbourn
//
// esvector.cpp
//
// Contains the various arithmetic operations for the EschVector class
// in the 'math' header.
//
//      esch_flt_cross
//      esch_dot
//      esch_flt_magnitude
//      esch_flt_normalize
//
//

//
//
//                                Includes
//
//

#include "escher.hpp"

//
//
//                                 Code
//
//

//Ŀ
// esch_flt_cross                                                           
//                                                                          
// Computes the cross-product of the two vectors.                           
//
extern "C" EschVector *esch_flt_cross(const EschVector *v1,
                                      const EschVector *v2,
                                      EschVector *dest)
{
//
// (i', j', k') = v1 CROSS v2
//
//       i' = (v1.j * v2.k) - (v1.k * v2.j)
//       j' = (v1.k * v2.i) - (v1.i * v2.k)
//       k' = (v1.i * v2.j) - (v1.j * v2.i)
//

    float newi = (v1->j*v2->k) - (v1->k*v2->j);
    float newj = (v1->k*v2->i) - (v1->i*v2->k);
    float newk = (v1->i*v2->j) - (v1->j*v2->i);

    dest->i = newi;
    dest->j = newj;
    dest->k = newk;

    return dest;
}


//Ŀ
// esch_dot                                                                 
//                                                                          
// Returns the dot product of two vectors.                                  
//
extern "C" float esch_dot(const EschVector *v1, const EschVector *v2)
{
//
// x = v1 DOT v2 =  (v1.i*v2.i) + (v1.j*v2.j) + (v1.k*v2.k)
//

    return ((v1->i*v2->i)
            + (v1->j*v2->j)
            + (v1->k*v2->k));
}


//Ŀ
// esch_flt_magnitude                                                       
//                                                                          
// Returns the magnitude of the vector.                                     
//
extern "C" float esch_flt_magnitude(const EschVector *vect)
{
// magnitude = sqrt(i^2 + j^2 + k^3)

    return esch_sqrt(vect->i*vect->i
                     + vect->j*vect->j
                     + vect->k*vect->k);
}


//Ŀ
// esch_flt_normalize                                                       
//                                                                          
// Normalizes the vector (if the magnitude is too small, leaves the vector  
// unchanged).                                                              
//
extern "C" void esch_flt_normalize(EschVector *vect)
{
    float mag = esch_sqrt(vect->i*vect->i
                          + vect->j*vect->j
                          + vect->k*vect->k);

    if (mag >= 0.0001f)
    {
        vect->i /= mag;
        vect->j /= mag;
        vect->k /= mag;
    }
}

// End of module - esvector.cpp 

