/** \file 3D_SpecObject3D.h
    Specialized cases of Object3D

Copyright (c) 1998-1999 by Amir Geva.
This file is part of the Photon Game Development library,
beta release version 0.25.
Permission is granted to use and copy this file for non-commercial use only.
Please contact the author concerning commercial usage. 
Amir Geva makes no representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.

*/
#ifndef H_3D_SPECOBJECT3D
#define H_3D_SPECOBJECT3D

#include <stdlib.h>
#include <3D_Object3D.h>

// Provides random, but constant rotation, and constant speed.
class SplinterObject3D : public Object3D
{
public:
  SplinterObject3D(Mesh* O) : 
    Object3D(O), 
    speed(randVector3D()),
    spinSpeed(randVector3D()),
    m_Life(100.0f)
  {}

  Vector3D randVector3D(float Size=1.0f)
  {
     const float Mod = Size/RAND_MAX;
     return Vector3D(rand() * Mod, rand() * Mod, rand() * Mod);
  }

  long advance(float Fraction)
  {
    m_Life-=Fraction;
    relocate(Fraction * speed);
    rotate(Fraction * spinSpeed);
    long rc=Object3D::advance(Fraction);
    if (rc!=0) return rc;
    return (m_Life<=0.0f);
  }

  Vector3D speed;
  Vector3D spinSpeed;
  float m_Life;
};

// Provides constant speed with no rotation.
// Suits a rocket, or a bullet.
class Rocket : public Object3D
{
public:
  Rocket(Mesh* O, Mesh* Launcher, float Range, float Speed) : 
    Object3D(O), 
    m_Range(Range), 
    m_Speed(Speed),
    m_Life(0.0f)
  {
    align(Launcher);                    // Locates where launcher is.
    Vector3D D=Launcher->getDirection(15.0f); // Initially places 15 unit ahead of launcher
    relocate(D);
  }

  long advance(float Fraction)
  {
    float Adv=m_Speed*Fraction;
    forward(Adv);
    m_Life+=Adv;
    long rc=Object3D::advance(Fraction);
    if (rc!=0) return rc;
    return (m_Life>m_Range); // Destroy itself if passed the range.
  }

  float m_Life;
  float m_Range;
  float m_Speed;
};


#endif // H_3D_SPECOBJECT3D