/** \file 3D_Radar.h
    Generic 3D Object tracking system.

Copyright (c) 1998-1999 by Amir Geva.
This file is part of the Photon Game Development library,
beta release version 0.25.
Permission is granted to use and copy this file for non-commercial use only.  
Please contact the author concerning commercial usage. 
Amir Geva makes no representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.

*/
#ifndef H_3D_RADAR
#define H_3D_RADAR

/** A generic 3D object tracking system.
    Can be subclassed to use the information anyway needed.
*/
class Radar
{
public:
  /** Construct the abstract tracking object. */
           Radar();
  virtual ~Radar();

  /** Sets the world Range, and a pixel viewsize to scale positions by.
      Try playing with the range, and see what results you get.
      The ViewSize is the size (in pixels) of the actual representation.
      For example, if you plot the radar on a 200x200 area, use ViewSize=200 */
  long setRange(float Range, int ViewSize);

  /** Add an object to the radar.  The coordinates are relative to the radar's
      position and orientation */
  long addItem(float x, float y, float z);

  /** Remove all objects.  Call before each frame. */
  long clear();

  /** Returns a non-zero value if an error occured. */
  long status();
  
  /** Call this to reset the iteration through the objects
      Used in rendering implementation. */
  long iterate();

  /** Retrieves the next object's position.  Returns 0 if an object is available
      and a non-zero value if no more objects are available.
      Returns object's position on the grid in the reference variables. */
  long getNext(int& x, int& y, int& z);

  /** Implement this in subclasses to provide actual visible radar. */
  virtual long render()=0;

protected:
  class RadarImpl* m_RadarData;
};

#endif // H_3D_RADAR