#include "CON_All.h"

int initConsole(int& Width, int& Height, int& FullScreen, int& Flags, Screen* S)
{
  if (!S->isModeAvailable(640,480)) return -1;
  Width=640;
  Height=480;
  FullScreen=1;
  Flags=0;
  return 0;
}

// Global variables for 3D environment
Screen3D *S3D=NULL;
Camera   *Cam=NULL;
Mesh     *O3D=NULL;
Light    *SL=NULL;
ResourceStream *RS;
TextureCache   *TC;
SoundClip      *SC;

int action(Console* C)
{
  Screen* S=C->getScreen();
  if (S3D==NULL)
  {
    // First time initialization.  Init 3D Environment
    //
    // Create 3D Screen Object.
    S3D=initScreen3D();
    // Create Camera.
    Cam=newCamera();
    // Activate camera, and set viewing parameters.
    Cam->activate();
    Cam->setViewable(120,50,400,300);
    Cam->setPosition(10.0f,0.0f,0.0f);
    Cam->setDirection(-1.0f,0.0f,0.0f,0.0f,1.0f,0.0f);
    // Create a light object and place it in the camera scene
    //SL=newSunLight(Vector3D(10.0f,10.0f,-20.0f),fColor(1.0f,1.0f,0.0f));
    
    SL=newSpotLight(Vector3D(1.5f,0.0f,-0.3f),Vector3D(-1.0f,0.0f,0.0f),
                    fColor(1.0f,1.0f,1.0f),20.0f);
    
    Cam->addLight(SL);
    RS=newResourceStream();
    TC=newTextureCache(RS);
    // Create a 3D object, and load its data from an .X file
    loadXFile("tiger.x",O3D,TC,2.0f);
    O3D->setPosition(0.0f,0.0f,0.0f);
  }
  S->clear(S->getColor(90,90,90)); // Clear the entire screen.  (Optional)
  Cam->clear(0x303030); // Clear camera display (clears visible display and depth buffer)
  //O3D->rotate(0.0001f,0.002f,0.0003f); // Make the object spin
  float f = getFrameTime();
  f *= 5;
  O3D->rotate(f*0.13f,f*0.013f,f*0.017f); // Make the object spin
  S3D->beginScene(); // Must be called before 3D rendering
  S3D->renderObject(O3D); // Render object
  S3D->endScene(); // Must be called after 3D rendering
  S->flip(); // Move rendering surface to screen
  int ID,Pressed;
  int EndFlag=C->getKeyboard()->getKey(ID,Pressed); // Stop on any key
  if (ID!=DIK_ESCAPE) EndFlag=0;
  if (EndFlag)
  {
    // Destroy all globally allocated objects, before exiting.
    TC->release();
    SL->release();
    Cam->release();
    O3D->release();
  }     ////
  return EndFlag;
}