/** \file CON_Texture.h 
    Cache for 3D Textures. 

Copyright (c) 1998-1999 by Amir Geva.
This file is part of the Photon Game Development library,
beta release version 0.25.  
Permission is granted to use and copy this file for non-commercial use only.  
Please contact the author concerning commercial usage. 
Amir Geva makes no representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.

*/
#ifndef CON_TEXTURE
#define CON_TEXTURE

#include <CON_Bitmap.h>

/** This is the interface for a texture. */
class Texture : public virtual Drawable
{
public:
};

/** This is a cache of textures, holding textures by name to be retrieved
    at any time. */
class TextureCache : public Interface
{
public:
  /** retrieve a texture (returns a handle to be used in rendering)
      It will load the image from a resource (file). */
  virtual Texture* load(const char* Name) = 0;
};

#endif // CON_TEXTURE