/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.images;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;

public class ImageUtilities {
    static /* synthetic */ Class class$org$freehep$util$images$ImageUtilities;

    private ImageUtilities() {
    }

    public static RenderedImage createRenderedImage(Image image, ImageObserver observer, Color bkg) {
        if (bkg == null && image instanceof RenderedImage) {
            return (RenderedImage)((Object)image);
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(observer), image.getHeight(observer), bkg == null ? 2 : 1);
        Graphics g2 = bufferedImage.getGraphics();
        if (bkg == null) {
            g2.drawImage(image, 0, 0, observer);
        } else {
            g2.drawImage(image, 0, 0, bkg, observer);
        }
        return bufferedImage;
    }

    public static RenderedImage createRenderedImage(RenderedImage image, Color bkg) {
        if (bkg == null) {
            return image;
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        Graphics2D g2 = (Graphics2D)bufferedImage.getGraphics();
        g2.setBackground(bkg);
        g2.clearRect(0, 0, image.getWidth(), image.getHeight());
        g2.drawRenderedImage(image, new AffineTransform());
        return bufferedImage;
    }

    public static byte[] getBytes(Image image, Color bkg, String code, int pad, ImageObserver observer) {
        return ImageUtilities.getBytes(ImageUtilities.createRenderedImage(image, observer, bkg), bkg, code, pad);
    }

    public static byte[] getBytes(RenderedImage image, Color bkg, String code, int pad) {
        boolean preMultiply;
        if (pad < 1) {
            pad = 1;
        }
        Raster raster = image.getData();
        int width = image.getWidth();
        int height = image.getHeight();
        boolean bl = preMultiply = code.charAt(0) == '*';
        if (preMultiply) {
            code = code.substring(1);
        }
        int pixelSize = code.length();
        int size = width * height * pixelSize;
        int index = 0;
        byte[] bytes = new byte[size += width % pad * height];
        int y2 = 0;
        while (y2 < height) {
            int x2 = 0;
            while (x2 < width) {
                int[] rgba = raster.getPixel(x2, y2, (int[])null);
                if (preMultiply && rgba.length > 3) {
                    if (bkg == null) {
                        bkg = Color.BLACK;
                    }
                    double alpha = (double)rgba[3] / 255.0;
                    rgba[0] = (int)(alpha * (double)rgba[0] + (1.0 - alpha) * (double)bkg.getRed());
                    rgba[1] = (int)(alpha * (double)rgba[1] + (1.0 - alpha) * (double)bkg.getGreen());
                    rgba[2] = (int)(alpha * (double)rgba[2] + (1.0 - alpha) * (double)bkg.getBlue());
                }
                int i2 = 0;
                while (i2 < code.length()) {
                    switch (code.charAt(i2)) {
                        case 'A': 
                        case 'a': {
                            bytes[index] = rgba.length > 3 ? (int)rgba[3] : -1;
                            break;
                        }
                        case 'R': 
                        case 'r': {
                            bytes[index] = (byte)rgba[0];
                            break;
                        }
                        case 'G': 
                        case 'g': {
                            bytes[index] = (byte)rgba[1];
                            break;
                        }
                        case 'B': 
                        case 'b': {
                            bytes[index] = (byte)rgba[2];
                            break;
                        }
                        default: {
                            System.err.println((class$org$freehep$util$images$ImageUtilities == null ? ImageUtilities.class$("org.freehep.util.images.ImageUtilities") : class$org$freehep$util$images$ImageUtilities).getClass() + ": Invalid code in '" + code + "'");
                        }
                    }
                    ++index;
                    ++i2;
                }
                ++x2;
            }
            int i3 = 0;
            while (i3 < width % pad) {
                bytes[index] = 0;
                ++index;
                ++i3;
            }
            ++y2;
        }
        return bytes;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

