/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.ps;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import org.freehep.graphics2d.GenericTagHandler;
import org.freehep.graphics2d.PrintColor;
import org.freehep.graphics2d.TagString;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.AbstractVectorGraphicsIO;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.MultiPageDocument;
import org.freehep.graphicsio.PageConstants;
import org.freehep.graphicsio.VectorGraphicsIO;
import org.freehep.graphicsio.font.FontUtilities;
import org.freehep.graphicsio.ps.EPSIEncoder;
import org.freehep.graphicsio.ps.MappedColor;
import org.freehep.graphicsio.ps.PSFontTable;
import org.freehep.graphicsio.ps.PSPathConstructor;
import org.freehep.graphicsio.raw.RawImageWriteParam;
import org.freehep.util.UserProperties;
import org.freehep.util.images.ImageUtilities;
import org.freehep.util.io.ASCII85OutputStream;
import org.freehep.util.io.FlateOutputStream;

public class PSGraphics2D
extends AbstractVectorGraphicsIO
implements MultiPageDocument,
FontUtilities.ShowString {
    private static final String rootKey = (class$org$freehep$graphicsio$ps$PSGraphics2D == null ? (class$org$freehep$graphicsio$ps$PSGraphics2D = PSGraphics2D.class$("org.freehep.graphicsio.ps.PSGraphics2D")) : class$org$freehep$graphicsio$ps$PSGraphics2D).getName();
    public static final String BACKGROUND = rootKey + "." + "Background";
    public static final String BACKGROUND_COLOR = rootKey + "." + "BackgroundColor";
    public static final String PAGE_SIZE = rootKey + "." + "PageSize";
    public static final String PAGE_MARGINS = rootKey + "." + "PageMargins";
    public static final String ORIENTATION = rootKey + "." + "Orientation";
    public static final String FIT_TO_PAGE = rootKey + "." + "FitToPage";
    public static final String EMBED_FONTS = rootKey + "." + "EmbedFonts";
    public static final String EMBED_FONTS_AS = rootKey + "." + "EmbedFontsAs";
    public static final String FOR = rootKey + "." + "For";
    public static final String TITLE = rootKey + "." + "Title";
    public static final String PREVIEW = rootKey + ".Preview";
    public static final String PREVIEW_BITS = rootKey + ".PreviewBits";
    public static final String WRITE_IMAGES_AS = rootKey + "." + "WriteImagesAs";
    private static final UserProperties defaultProperties = new UserProperties();
    public static final String version = "$Revision: 1.18 $";
    public static final int LEVEL_2 = 2;
    public static final int LEVEL_3 = 3;
    private static final double FONTSIZE_CORRECTION = 1.0;
    private static boolean enableClip;
    private PSFontTable fontTable;
    protected OutputStream ros;
    protected PrintStream os;
    private boolean fontSet = false;
    private boolean multiPage;
    private int currentPage;
    private int postscriptLevel = 3;
    private static String[] psSymbolNames;
    private static Hashtable compositeFonts;
    private static String[][] psAlignments;
    static /* synthetic */ Class class$org$freehep$graphicsio$ps$PSGraphics2D;

    public static Properties getDefaultProperties() {
        return defaultProperties;
    }

    public PSGraphics2D(File file, Dimension size) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), size);
    }

    public PSGraphics2D(File file, Component component) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), component);
    }

    public PSGraphics2D(OutputStream os, Dimension size) {
        super(size, false);
        this.init(os);
    }

    public PSGraphics2D(OutputStream os, Component component) {
        super(component, false);
        this.init(os);
    }

    private void init(OutputStream os) {
        this.ros = new BufferedOutputStream(os);
        this.initProperties(defaultProperties);
        this.fontTable = new PSFontTable(this.ros, this.getFontRenderContext());
        this.multiPage = false;
        this.currentPage = 0;
        this.fontSet = false;
    }

    protected PSGraphics2D(PSGraphics2D graphics, boolean doRestoreOnDispose) {
        super(graphics, doRestoreOnDispose);
        this.ros = graphics.ros;
        this.os = graphics.os;
        this.fontSet = graphics.fontSet;
        this.fontTable = graphics.fontTable;
        this.multiPage = graphics.multiPage;
        this.currentPage = graphics.currentPage;
    }

    public void setMultiPage(boolean multiPage) {
        this.multiPage = multiPage;
    }

    public boolean isMultiPage() {
        return this.multiPage;
    }

    public static void setClipEnabled(boolean enabled) {
        enableClip = enabled;
    }

    private Rectangle getBoundingBox() {
        Dimension pageSize = PageConstants.getSize(this.getProperty(PAGE_SIZE));
        Insets margins = this.getPropertyInsets(PAGE_MARGINS);
        boolean isPortrait = this.getProperty(ORIENTATION).equals("Portrait");
        double awidth = pageSize.width - margins.left - margins.right;
        double aheight = pageSize.height - margins.top - margins.bottom;
        Dimension size = this.getSize();
        double iwidth = isPortrait ? size.width : size.height;
        double iheight = isPortrait ? size.height : size.width;
        double sf = Math.min(awidth / iwidth, aheight / iheight);
        if (!this.isProperty(FIT_TO_PAGE)) {
            sf = Math.min(sf, 1.0);
        }
        double x0 = awidth / 2.0 + (double)margins.left - sf * iwidth / 2.0;
        double y0 = aheight / 2.0 + (double)margins.bottom - sf * iheight / 2.0;
        double x1 = x0 + sf * iwidth;
        double y1 = y0 + sf * iheight;
        int llx = (int)x0;
        int lly = (int)y0;
        int urx = (int)Math.ceil(x1);
        int ury = (int)Math.ceil(y1);
        return new Rectangle(llx, lly, urx - llx, ury - lly);
    }

    public void writeHeader() throws IOException {
        this.os = new PrintStream(this.ros, true);
        if (!this.isMultiPage()) {
            Dimension size = this.getSize();
            this.resetClip(new Rectangle(0, 0, size.width, size.height));
        }
        this.os.println("%!PS-Adobe-3.0" + (this.isMultiPage() ? "" : " EPSF-3.0"));
        if (!this.isMultiPage()) {
            Rectangle bbox = this.getBoundingBox();
            this.os.println("%%BoundingBox: " + bbox.x + " " + bbox.y + " " + (bbox.x + bbox.width) + " " + (bbox.y + bbox.height));
        }
        String producer = this.getClass().getName();
        if (!this.isDeviceIndependent()) {
            producer = producer + " " + version.substring(1, version.length() - 1);
        }
        this.os.println("%%Creator: " + this.getCreator());
        this.os.println("%%Producer: " + producer);
        this.os.println("%%For: " + this.getProperty(FOR));
        this.os.println("%%Title: " + this.getProperty(TITLE));
        if (!this.isDeviceIndependent()) {
            this.os.println("%%CreationDate: " + DateFormat.getDateTimeInstance(0, 0).format(new Date()));
        }
        this.os.println("%%LanguageLevel: " + this.postscriptLevel);
        this.os.println("%%EndComments");
        if (this.isProperty(PREVIEW) && this.getComponent() != null) {
            Rectangle size = this.getComponent().getBounds();
            BufferedImage image = new BufferedImage(size.width, size.height, 2);
            Graphics imageGraphics = image.getGraphics();
            this.getComponent().print(imageGraphics);
            EPSIEncoder encoder = new EPSIEncoder(image, this.ros, this.getPropertyInt(PREVIEW_BITS), this.getProperty(ORIENTATION).equals("Portrait"));
            encoder.encode();
        }
        this.writeProlog();
    }

    private void writeProlog() {
        this.os.println("%%BeginProlog");
        VectorGraphicsIO.copyResourceTo((Object)this, "PSProlog.txt", this.os);
        this.os.println("%%EndProlog");
        this.os.println();
        if (!this.isMultiPage()) {
            this.openPage(this.getSize(), null, this.getComponent());
        }
    }

    public void writeBackground() throws IOException {
        if (this.isProperty(BACKGROUND)) {
            this.setBackground(this.getPropertyColor(BACKGROUND_COLOR));
            this.clearRect(0.0, 0.0, (double)this.getSize().width, (double)this.getSize().height);
        } else {
            this.setBackground(this.getComponent() != null ? this.getComponent().getBackground() : Color.WHITE);
            this.clearRect(0.0, 0.0, (double)this.getSize().width, (double)this.getSize().height);
        }
    }

    public void writeTrailer() throws IOException {
        if (!this.isMultiPage()) {
            this.closePage();
        }
        this.os.println();
        this.os.println("%%Trailer");
        if (this.isMultiPage()) {
            this.os.println("%%Pages: " + this.currentPage);
        }
        this.os.println("%%EOF");
    }

    public void closeStream() throws IOException {
        this.ros.close();
        this.os.close();
    }

    public void openPage(Component component) throws IOException {
        this.openPage(component.getSize(), component.getName(), component);
    }

    public void openPage(Dimension size, String title) throws IOException {
        this.openPage(size, title, null);
    }

    private void openPage(Dimension size, String title, Component component) {
        ++this.currentPage;
        this.resetClip(new Rectangle(0, 0, size.width, size.height));
        Dimension pageSize = PageConstants.getSize(this.getProperty(PAGE_SIZE));
        Insets margins = this.getPropertyInsets(PAGE_MARGINS);
        String string = title = title == null ? "" + this.currentPage : "(" + title + ")";
        if (this.isMultiPage()) {
            this.os.println("%%Page: " + title + " " + this.currentPage);
        }
        this.os.println(this.isMultiPage() ? "%%BeginPageSetup" : "%%BeginSetup");
        this.os.println("save");
        this.os.println("procDict begin");
        this.os.println("printColorMap begin");
        this.os.println(pageSize.width + " " + pageSize.height + " setpagesize");
        this.os.println(margins.left + " " + margins.bottom + " " + margins.top + " " + margins.right + " setmargins");
        this.os.println("0 0 setorigin");
        this.os.println(size.width + " " + size.height + " setsize");
        this.os.println(this.isProperty(FIT_TO_PAGE) ? "fittopage" : "naturalsize");
        this.os.println(this.getProperty(ORIENTATION).equals("Portrait") ? "portrait" : "landscape");
        this.os.println("imagescale");
        this.os.println("cliptobounds");
        this.os.println("setbasematrix");
        this.os.println("/Helvetica 10 sf");
        this.os.println("defaultGraphicsState");
        this.os.println(this.isMultiPage() ? "%%EndPageSetup" : "%%EndSetup");
        this.os.println();
        try {
            this.writeGraphicsState();
            this.writeBackground();
        }
        catch (Exception e2) {
            this.handleException(e2);
        }
    }

    public void closePage() {
        this.os.println("end end restore showpage");
        if (this.isMultiPage()) {
            this.os.println("%%PageTrailer");
        }
    }

    public void setHeader(Font font, TagString left, TagString center, TagString right, int underlineThickness) {
    }

    public void setFooter(Font font, TagString left, TagString center, TagString right, int underlineThickness) {
    }

    public Graphics create() {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException e2) {
            this.handleException(e2);
        }
        return new PSGraphics2D(this, true);
    }

    public Graphics create(double x2, double y2, double width, double height) {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException e2) {
            this.handleException(e2);
        }
        PSGraphics2D graphics = new PSGraphics2D(this, true);
        graphics.translate(x2, y2);
        graphics.clipRect(0.0, 0.0, width, height);
        return graphics;
    }

    protected void writeGraphicsSave() throws IOException {
        this.os.println("q");
    }

    protected void writeGraphicsRestore() throws IOException {
        this.os.println("Q");
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        this.os.println(this.fixedPrecision(x2) + " " + this.fixedPrecision(y2) + " " + this.fixedPrecision(x1) + " " + this.fixedPrecision(y1) + " L");
    }

    public void drawRect(double x2, double y2, double width, double height) {
        this.os.println("bias " + this.fixedPrecision(x2) + " " + this.fixedPrecision(y2) + " " + this.fixedPrecision(width) + " " + this.fixedPrecision(height) + " rs unbias");
    }

    public void fillRect(double x2, double y2, double width, double height) {
        this.os.println(this.fixedPrecision(x2) + " " + this.fixedPrecision(y2) + " " + this.fixedPrecision(width) + " " + this.fixedPrecision(height) + " rf");
    }

    public void drawArc(double x2, double y2, double width, double height, double startAngle, double arcAngle) {
        this.os.println(this.fixedPrecision(startAngle) + " " + this.fixedPrecision(startAngle + arcAngle) + " " + this.fixedPrecision(x2) + " " + this.fixedPrecision(y2) + " " + this.fixedPrecision(width) + " " + this.fixedPrecision(height) + " OVL");
    }

    public void fillArc(double x2, double y2, double width, double height, double startAngle, double arcAngle) {
        this.os.println(this.fixedPrecision(startAngle) + " " + this.fixedPrecision(startAngle + arcAngle) + " " + this.fixedPrecision(x2) + " " + this.fixedPrecision(y2) + " " + this.fixedPrecision(width) + " " + this.fixedPrecision(height) + " FOVL");
    }

    public void drawOval(double x2, double y2, double width, double height) {
        this.os.println("0 360 " + this.fixedPrecision(x2) + " " + this.fixedPrecision(y2) + " " + this.fixedPrecision(width) + " " + this.fixedPrecision(height) + " OVL");
    }

    public void fillOval(double x2, double y2, double width, double height) {
        this.os.println("0 360 " + this.fixedPrecision(x2) + " " + this.fixedPrecision(y2) + " " + this.fixedPrecision(width) + " " + this.fixedPrecision(height) + " FOVL");
    }

    public void drawRoundRect(double x2, double y2, double width, double height, double arcWidth, double arcHeight) {
        this.os.println(this.fixedPrecision(x2) + " " + this.fixedPrecision(y2) + " " + this.fixedPrecision(width) + " " + this.fixedPrecision(height) + " " + this.fixedPrecision(arcWidth) + " " + this.fixedPrecision(arcHeight) + " RREC");
    }

    public void fillRoundRect(double x2, double y2, double width, double height, double arcWidth, double arcHeight) {
        this.os.println(this.fixedPrecision(x2) + " " + this.fixedPrecision(y2) + " " + this.fixedPrecision(width) + " " + this.fixedPrecision(height) + " " + this.fixedPrecision(arcWidth) + " " + this.fixedPrecision(arcHeight) + " FRREC");
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints > 1) {
            this.os.println(nPoints - 1 + " " + xPoints[0] + " " + yPoints[0] + " OPL");
            int i2 = 1;
            while (i2 < nPoints) {
                this.os.println(xPoints[i2] + " " + yPoints[i2]);
                ++i2;
            }
        }
    }

    public void drawPolyline(double[] xPoints, double[] yPoints, int nPoints) {
        if (nPoints > 1) {
            this.os.println(nPoints - 1 + " " + xPoints[0] + " " + yPoints[0] + " OPL");
            int i2 = 1;
            while (i2 < nPoints) {
                this.os.println(this.fixedPrecision(xPoints[i2]) + " " + this.fixedPrecision(yPoints[i2]));
                ++i2;
            }
        }
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints > 1) {
            this.os.println(nPoints - 1 + " " + xPoints[0] + " " + yPoints[0] + " CPL");
            int i2 = 1;
            while (i2 < nPoints) {
                this.os.println(xPoints[i2] + " " + yPoints[i2]);
                ++i2;
            }
        }
    }

    public void drawPolygon(double[] xPoints, double[] yPoints, int nPoints) {
        if (nPoints > 1) {
            this.os.println(nPoints - 1 + " " + xPoints[0] + " " + yPoints[0] + " CPL");
            int i2 = 1;
            while (i2 < nPoints) {
                this.os.println(this.fixedPrecision(xPoints[i2]) + " " + this.fixedPrecision(yPoints[i2]));
                ++i2;
            }
        }
    }

    public void drawPolygon(Polygon p2) {
        this.drawPolygon(p2.xpoints, p2.ypoints, p2.npoints);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints > 1) {
            this.os.println(nPoints - 1 + " " + xPoints[0] + " " + yPoints[0] + " FPL");
            int i2 = 1;
            while (i2 < nPoints) {
                this.os.println(xPoints[i2] + " " + yPoints[i2]);
                ++i2;
            }
        }
    }

    public void fillPolygon(double[] xPoints, double[] yPoints, int nPoints) {
        if (nPoints > 1) {
            this.os.println(nPoints - 1 + " " + xPoints[0] + " " + yPoints[0] + " FPL");
            int i2 = 1;
            while (i2 < nPoints) {
                this.os.println(this.fixedPrecision(xPoints[i2]) + " " + this.fixedPrecision(yPoints[i2]));
                ++i2;
            }
        }
    }

    public void fillPolygon(Polygon p2) {
        this.fillPolygon(p2.xpoints, p2.ypoints, p2.npoints);
    }

    private String escapeString(String str) {
        if (!this.isProperty(EMBED_FONTS) && PSGraphics2D.isComposite(this.fontTable.fontReference(this.getFont(), this.isProperty(EMBED_FONTS), this.getProperty(EMBED_FONTS_AS)))) {
            return this.convertToUnicodeString(str);
        }
        StringBuffer temp = new StringBuffer(str);
        int i2 = 0;
        while (i2 < temp.length()) {
            char c2 = temp.charAt(i2);
            if (c2 == '(' || c2 == ')' || c2 == '\\' || c2 == '%') {
                temp.insert(i2++, '\\');
            }
            if (c2 == '\u0000') {
                temp.setCharAt(i2, '?');
            }
            ++i2;
        }
        return temp.toString();
    }

    public void drawSymbol(double x2, double y2, double size, int symbol) {
        if (size <= 0.0) {
            return;
        }
        this.os.print(this.fixedPrecision(x2) + " " + this.fixedPrecision(y2) + " " + this.fixedPrecision(size) + " ");
        this.os.println(symbol < 0 || symbol >= 10 ? "plus" : psSymbolNames[symbol]);
    }

    public void fillSymbol(double x2, double y2, double size, int symbol) {
        if (size <= 0.0) {
            return;
        }
        this.os.print(this.fixedPrecision(x2) + " " + this.fixedPrecision(y2) + " " + this.fixedPrecision(size) + " ");
        if (symbol < 0 || symbol >= 10) {
            this.os.println("plus");
            return;
        }
        if (symbol >= 5) {
            this.os.print("f");
        }
        this.os.println(psSymbolNames[symbol]);
    }

    public void draw(Shape shape) {
        try {
            this.writePath(shape);
            this.os.println("S");
        }
        catch (IOException e2) {
            this.handleException(e2);
        }
    }

    public void fill(Shape shape) {
        try {
            boolean eofill = this.writePath(shape);
            this.os.println(eofill ? "f*" : "f");
        }
        catch (IOException e2) {
            this.handleException(e2);
        }
    }

    public void fillAndDraw(Shape shape, Color fillColor) {
        try {
            this.setPSColor(fillColor, true);
            boolean eofill = this.writePath(shape);
            this.os.println(eofill ? "B*" : "B");
        }
        catch (IOException e2) {
            this.handleException(e2);
        }
    }

    public void copyArea(int x2, int y2, int width, int height, int dx, int dy) {
        this.writeWarning(this.getClass() + ": copyArea(int, int, int, int, int, int) not implemented.");
    }

    protected void writeImage(RenderedImage image, AffineTransform xform, Color bkg) throws IOException {
        byte[] imageBytes;
        String encode;
        if (bkg == null) {
            bkg = this.getBackground();
        }
        image = ImageUtilities.createRenderedImage(image, bkg);
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        AffineTransform imageTransform = new AffineTransform((double)imageWidth, 0.0, 0.0, (double)imageHeight, 0.0, 0.0);
        xform.concatenate(imageTransform);
        this.os.println("gsave /DeviceRGB setcolorspace");
        this.transform(xform);
        this.os.println("<<");
        this.os.println("/ImageType 1");
        this.os.println("/Width " + imageWidth + "  /Height " + imageHeight);
        this.os.println("/BitsPerComponent 8");
        this.os.println("/Decode [0 1 0 1 0 1]");
        this.os.println("/ImageMatrix [" + imageWidth + " 0 0 " + imageHeight + " 0 0]");
        String writeAs = this.getProperty(WRITE_IMAGES_AS);
        byte[] flateBytes = null;
        if (writeAs.equals("ZLIB") || writeAs.equals("Smallest Size")) {
            ByteArrayOutputStream flate = new ByteArrayOutputStream();
            ASCII85OutputStream flate85 = new ASCII85OutputStream(flate);
            FlateOutputStream fos = new FlateOutputStream(flate85);
            UserProperties props = new UserProperties();
            props.setProperty(RawImageWriteParam.BACKGROUND, bkg);
            props.setProperty(RawImageWriteParam.CODE, "RGB");
            props.setProperty(RawImageWriteParam.PAD, 1);
            ImageGraphics2D.writeImage(image, "raw", (Properties)props, (OutputStream)fos);
            fos.close();
            flateBytes = flate.toByteArray();
        }
        byte[] jpgBytes = null;
        if (writeAs.equals("JPG") || writeAs.equals("Smallest Size")) {
            ByteArrayOutputStream jpg = new ByteArrayOutputStream();
            ASCII85OutputStream jpg85 = new ASCII85OutputStream(jpg);
            ImageGraphics2D.writeImage(image, "jpg", new Properties(), (OutputStream)jpg85);
            jpg85.close();
            jpgBytes = jpg.toByteArray();
        }
        if (writeAs.equals("ZLIB")) {
            encode = "Flate";
            imageBytes = flateBytes;
        } else if (writeAs.equals("JPG")) {
            encode = "DCT";
            imageBytes = jpgBytes;
        } else {
            encode = (double)jpgBytes.length < 0.5 * (double)flateBytes.length ? "DCT" : "Flate";
            imageBytes = encode.equals("DCT") ? jpgBytes : flateBytes;
        }
        this.os.println("/DataSource currentfile /ASCII85Decode filter /" + encode + "Decode filter ");
        this.os.println(">> image");
        this.os.write(imageBytes);
        this.os.println("");
        this.os.println("grestore");
    }

    protected void writeString(String str, double x2, double y2) throws IOException {
        this.showCharacterCodes(str, x2, y2);
    }

    public void drawString(String str, double x2, double y2, int horizontal, int vertical, boolean framed, Color frameColor, double frameWidth, boolean banner, Color bannerColor) {
        try {
            LineMetrics metrics = this.getFont().getLineMetrics(str, this.getFontRenderContext());
            double width = this.getFont().getStringBounds(str, this.getFontRenderContext()).getWidth();
            double height = metrics.getHeight();
            double descent = metrics.getDescent();
            Rectangle2D.Double textSize = new Rectangle2D.Double(0.0, descent - height, width, height);
            double adjustment = this.getFont().getSize2D() * 2.0f / 10.0f;
            Point2D textUL = this.drawFrameAndBanner(x2, y2, textSize, adjustment, framed, frameColor, frameWidth, banner, bannerColor, horizontal, vertical);
            this.drawString(str, textUL.getX(), textUL.getY());
        }
        catch (IOException e2) {
            this.handleException(e2);
        }
    }

    public void drawString(TagString str, double x2, double y2, int horizontal, int vertical, boolean framed, Color frameColor, double frameWidth, boolean banner, Color bannerColor) {
        try {
            GenericTagHandler tagHandler = new GenericTagHandler(this);
            Rectangle2D r2 = tagHandler.stringSize(str);
            double adjustment = this.getFont().getSize2D() * 2.0f / 10.0f;
            Point2D textUL = this.drawFrameAndBanner(x2, y2, r2, adjustment, framed, frameColor, frameWidth, banner, bannerColor, horizontal, vertical);
            tagHandler.print(str, textUL.getX(), textUL.getY());
        }
        catch (IOException e2) {
            this.handleException(e2);
        }
    }

    public void drawString(AttributedCharacterIterator iterator, float x2, float y2) {
        this.writeWarning(this.getClass() + ": drawString(AttributedCharacterIterator, float, float) not implemented.");
    }

    public void drawGlyphVector(GlyphVector g2, float x2, float y2) {
        this.writeWarning(this.getClass() + ": drawGlyphVector(GlyphVector, float, float) not implemented.");
    }

    public void setTransform(AffineTransform tx) {
        super.setTransform(tx);
        if (tx == null) {
            tx = new AffineTransform();
        }
        this.os.println("[ " + this.fixedPrecision(tx.getScaleX()) + " " + this.fixedPrecision(tx.getShearY()) + " " + this.fixedPrecision(tx.getShearX()) + " " + this.fixedPrecision(tx.getScaleY()) + " " + this.fixedPrecision(tx.getTranslateX()) + " " + this.fixedPrecision(tx.getTranslateY()) + " ] defaultmatrix matrix concatmatrix setmatrix");
    }

    public void transform(AffineTransform transform) {
        super.transform(transform);
        this.os.println("[ " + this.fixedPrecision(transform.getScaleX()) + " " + this.fixedPrecision(transform.getShearY()) + " " + this.fixedPrecision(transform.getShearX()) + " " + this.fixedPrecision(transform.getScaleY()) + " " + this.fixedPrecision(transform.getTranslateX()) + " " + this.fixedPrecision(transform.getTranslateY()) + " ] concat");
    }

    public void translate(double x2, double y2) {
        super.translate(x2, y2);
        this.os.println(this.fixedPrecision(x2) + " " + this.fixedPrecision(y2) + " translate");
    }

    public void rotate(double theta) {
        super.rotate(theta);
        this.os.println(this.fixedPrecision(Math.toDegrees(theta)) + " rotate");
    }

    public void scale(double sx, double sy) {
        super.scale(sx, sy);
        this.os.println(this.fixedPrecision(sx) + " " + this.fixedPrecision(sy) + " scale");
    }

    public void shear(double shx, double shy) {
        super.shear(shx, shy);
        this.os.println("[ 1.0 " + this.fixedPrecision(shy) + " " + this.fixedPrecision(shx) + " 1.0 0.0 0.0 ] concat");
    }

    protected void writeTransform(AffineTransform tx) throws IOException {
    }

    public void setClip(Shape shape) {
        this.clip(shape);
    }

    protected void writeClip(Rectangle r2) throws IOException {
        if (r2 == null) {
            return;
        }
        if (enableClip) {
            this.os.println(r2.x + " " + r2.y + " " + r2.width + " " + r2.height + " rc");
        }
    }

    protected void writeClip(Rectangle2D r2d) throws IOException {
        if (r2d == null) {
            return;
        }
        if (enableClip) {
            this.os.println(this.fixedPrecision(r2d.getX()) + " " + this.fixedPrecision(r2d.getY()) + " " + this.fixedPrecision(r2d.getWidth()) + " " + this.fixedPrecision(r2d.getHeight()) + " rc");
        }
    }

    protected void writeClip(Shape s2) throws IOException {
        if (s2 == null) {
            return;
        }
        boolean eofill = this.writePath(s2);
        this.os.println(eofill ? "W*" : "W");
    }

    private boolean writePath(Shape s2) throws IOException {
        this.os.println("newpath");
        PSPathConstructor path = new PSPathConstructor(this.os, true, false);
        return path.addPath(s2);
    }

    protected void writeWidth(float width) throws IOException {
        this.os.println(this.fixedPrecision(width) + " w");
    }

    protected void writeCap(int cap) throws IOException {
        switch (cap) {
            default: {
                this.os.println("0 J");
                break;
            }
            case 1: {
                this.os.println("1 J");
                break;
            }
            case 2: {
                this.os.println("2 J");
            }
        }
    }

    protected void writeJoin(int join) throws IOException {
        switch (join) {
            default: {
                this.os.println("0 j");
                break;
            }
            case 1: {
                this.os.println("1 j");
                break;
            }
            case 2: {
                this.os.println("2 j");
            }
        }
    }

    protected void writeMiterLimit(float limit) throws IOException {
        this.os.println(this.fixedPrecision(limit) + " M");
    }

    protected void writeDash(double[] dash, double phase) throws IOException {
        this.os.print("[ ");
        int i2 = 0;
        while (i2 < dash.length) {
            this.os.print(this.fixedPrecision(dash[i2]) + " ");
            ++i2;
        }
        this.os.println("] " + this.fixedPrecision(phase) + " d");
    }

    public void setPaintMode() {
        this.writeWarning(this.getClass() + ": setPaintMode() not implemented.");
    }

    public void setXORMode(Color c1) {
        this.writeWarning(this.getClass() + ": setXORMode(Color) not implemented.");
    }

    protected void writePaint(Color c2) throws IOException {
        this.setPSColor(c2, false);
    }

    protected void writePaint(GradientPaint paint) throws IOException {
        if (this.postscriptLevel >= 3) {
            float[] rgb1 = paint.getColor1().getRGBColorComponents(null);
            float[] rgb2 = paint.getColor2().getRGBColorComponents(null);
            Point2D p1 = paint.getPoint1();
            Point2D p2 = paint.getPoint2();
            this.os.println("<< /PatternType 2");
            this.os.println("   /Shading");
            this.os.println("   << /ShadingType 2");
            this.os.println("      /ColorSpace /DeviceRGB");
            this.os.println("      /Coords [" + p1.getX() + " " + p1.getY() + " " + p2.getX() + " " + p2.getY() + "]");
            this.os.println("      /Function");
            this.os.println("      << /FunctionType 2");
            this.os.println("         /Domain [0 1]");
            this.os.println("         /Range [0 1 0 1 0 1]");
            this.os.println("         /C0 [" + rgb1[0] + " " + rgb1[1] + " " + rgb1[2] + "]");
            this.os.println("         /C1 [" + rgb2[0] + " " + rgb2[1] + " " + rgb2[2] + "]");
            this.os.println("         /N 1");
            this.os.println("      >>");
            this.os.println("      /Extend [true true]");
            this.os.println("   >>");
            this.os.println(">>");
            this.os.println("matrix makepattern setpattern");
        } else {
            this.writeComment("Gradient fill not supported by ps level 2. Replacing with intermediate color.");
            this.setColor(PrintColor.mixColor(paint.getColor1(), paint.getColor2()));
        }
    }

    protected void writePaint(TexturePaint paint) throws IOException {
        BufferedImage img = paint.getImage();
        this.os.println("<< /PatternType 1");
        this.os.println("   /PaintType 1");
        this.os.println("   /TilingType 1");
        this.os.println("   /BBox [0 0 " + img.getWidth() + " " + img.getHeight() + "]");
        this.os.println("   /XStep " + paint.getAnchorRect().getWidth());
        this.os.println("   /YStep " + paint.getAnchorRect().getHeight());
        this.os.println("   /PaintProc");
        this.os.println("   {");
        this.os.println("     begin");
        this.os.println("     /DeviceRGB setcolorspace");
        this.os.println("     0 0 translate");
        this.os.println("     " + img.getWidth() + " " + img.getHeight() + " scale");
        this.os.println("     <<");
        this.os.println("     /ImageType 1");
        this.os.println("     /Width " + img.getWidth());
        this.os.println("     /Height " + img.getWidth());
        this.os.println("     /BitsPerComponent 8");
        this.os.println("     /Decode [0 1 0 1 0 1]");
        this.os.println("     /ImageMatrix [" + img.getWidth() + " 0 0 " + img.getHeight() + " 0 0]");
        this.os.println("     /DataSource ( Z  Z  Z  Z  Z  Z  Z  Z Z ZZ ZZ ZZ ZZ ZZ ZZ ZZ Z)");
        this.os.println("     >> image");
        this.os.println("     end");
        this.os.println("   } bind");
        this.os.println(">>");
        this.os.println("matrix makepattern setpattern");
    }

    protected void writePaint(Paint p2) throws IOException {
        this.writeWarning(this.getClass() + ": writePaint(Paint) not implemented for " + p2.getClass());
    }

    public void setFont(Font font) {
        if (!font.equals(this.getFont())) {
            this.fontSet = false;
        }
        super.setFont(font);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        this.writeWarning(this.getClass() + ": getDeviceConfiguration() not implemented.");
        return null;
    }

    public boolean hit(Rectangle rect, Shape s2, boolean onStroke) {
        this.writeWarning(this.getClass() + ": hit(Rectangle, Shape, boolean) not implemented.");
        return false;
    }

    public void writeComment(String s2) throws IOException {
        this.os.println("% " + s2);
    }

    public String toString() {
        return "PSGraphics2D";
    }

    private String convertToUnicodeString(String str) {
        StringBuffer codedString = new StringBuffer();
        int i2 = 0;
        while (i2 < str.length()) {
            char chr = str.charAt(i2);
            int cvalue = chr & 0xFF;
            int fvalue = (chr & 0xFF00) >>> 8;
            String cbyte = Integer.toOctalString(cvalue);
            String fbyte = Integer.toOctalString(fvalue);
            codedString.append('\\');
            int j2 = 0;
            while (j2 < 3 - fbyte.length()) {
                codedString.append('0');
                ++j2;
            }
            codedString.append(fbyte);
            if (cvalue < 32 || cvalue > 126 || cvalue == 92 || cvalue == 37 || cvalue == 40 || cvalue == 41) {
                codedString.append('\\');
                int j3 = 0;
                while (j3 < 3 - cbyte.length()) {
                    codedString.append('0');
                    ++j3;
                }
                codedString.append(cbyte);
            } else {
                codedString.append((char)cvalue);
            }
            ++i2;
        }
        return codedString.toString();
    }

    private TagString escapeTagString(TagString str) {
        return str;
    }

    private Point2D drawFrameAndBanner(double x2, double y2, Rectangle2D textSize, double adjustment, boolean framed, Color frameColor, double frameWidth, boolean banner, Color bannerColor, int horizontal, int vertical) throws IOException {
        Paint paint;
        double descent = textSize.getY() + textSize.getHeight();
        x2 = VectorGraphics.getXalignment(x2, textSize.getWidth(), horizontal);
        y2 = VectorGraphics.getYalignment(y2, textSize.getHeight(), descent, vertical);
        double rx = x2 - adjustment;
        double ry = y2 - textSize.getHeight() + descent - adjustment;
        double rw = textSize.getWidth() + 2.0 * adjustment;
        double rh = textSize.getHeight() + 2.0 * adjustment;
        if (banner) {
            paint = this.getPaint();
            this.setPaint(bannerColor);
            this.fillRect(rx, ry, rw, rh);
            this.setPaint(paint);
        }
        if (framed) {
            paint = this.getPaint();
            Stroke stroke = this.getStroke();
            this.setPaint(frameColor);
            this.setLineWidth(frameWidth);
            this.drawRect(rx, ry, rw, rh);
            this.setPaint(paint);
            this.setStroke(stroke);
        }
        return new Point2D.Double(x2, y2);
    }

    private void writeFont() {
        if (this.fontSet) {
            return;
        }
        this.fontSet = true;
        this.writeFont(this.getFont());
    }

    private void writeFont(Font font) {
        String fontName = this.fontTable.fontReference(font, this.isProperty(EMBED_FONTS), this.getProperty(EMBED_FONTS_AS));
        this.os.println("/" + fontName + " findfont " + (double)font.getSize() * 1.0 + " scalefont setfont");
    }

    public void showString(Font font, String str) {
        this.writeFont(font);
        this.os.println("(" + this.escapeString(str) + ") show");
    }

    private void showCharacterCodes(String str, double x2, double y2) {
        try {
            this.os.println(this.fixedPrecision(x2) + " " + this.fixedPrecision(y2) + " moveto");
            this.os.println("q 1 -1 scale");
            if (!this.isProperty(EMBED_FONTS) && PSGraphics2D.isComposite(this.fontTable.fontReference(this.getFont(), this.isProperty(EMBED_FONTS), this.getProperty(EMBED_FONTS_AS)))) {
                this.showString(this.getFont(), str);
            } else {
                FontUtilities.showString(this.getFont(), str, this.fontTable.getEncodingTable(), this);
            }
            this.os.println("Q");
        }
        catch (IOException e2) {
            this.handleException(e2);
        }
    }

    private void setPSColor(Color c2, boolean fillColor) {
        if (c2 != null) {
            if (c2 instanceof MappedColor) {
                MappedColor mc = (MappedColor)c2;
                if (!fillColor) {
                    if (mc.getBrightness() == 0) {
                        this.os.println(mc.getColorTag() + " vg&C");
                    } else {
                        this.os.println(mc.getColorTag() + " " + mc.getBrightness() + " darken vg&C");
                    }
                } else if (mc.getBrightness() == 0) {
                    this.os.println(mc.getColorTag() + " vg&DFC");
                } else {
                    this.os.println(mc.getColorTag() + " " + mc.getBrightness() + " darken vg&DFC");
                }
            } else {
                Color pc = this.getPrintColor(c2);
                double red = (double)pc.getRed() / 255.0;
                double green = (double)pc.getGreen() / 255.0;
                double blue = (double)pc.getBlue() / 255.0;
                this.os.print(this.fixedPrecision(red) + " " + this.fixedPrecision(green) + " " + this.fixedPrecision(blue) + " ");
                this.os.println(fillColor ? "rg" : "RG");
            }
        }
    }

    private String getPSAlignment(int vertical, int horizontal) {
        if (vertical >= 0 && vertical < 4 && horizontal >= 0 && horizontal < 4) {
            return psAlignments[horizontal][vertical];
        }
        return "0";
    }

    private static boolean isComposite(String name) {
        return compositeFonts.containsKey(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        defaultProperties.setProperty(BACKGROUND, false);
        defaultProperties.setProperty(BACKGROUND_COLOR, Color.GRAY);
        defaultProperties.setProperty(PAGE_SIZE, "International");
        defaultProperties.setProperty(PAGE_MARGINS, PageConstants.getMargins("Small"));
        defaultProperties.setProperty(ORIENTATION, "Landscape");
        defaultProperties.setProperty(FIT_TO_PAGE, true);
        defaultProperties.setProperty(EMBED_FONTS, false);
        defaultProperties.setProperty(EMBED_FONTS_AS, "Type3");
        defaultProperties.setProperty(FOR, "");
        defaultProperties.setProperty(TITLE, "");
        defaultProperties.setProperty(PREVIEW, false);
        defaultProperties.setProperty(PREVIEW_BITS, 8);
        defaultProperties.setProperty(WRITE_IMAGES_AS, "Smallest Size");
        enableClip = true;
        psSymbolNames = new String[10];
        compositeFonts = new Hashtable();
        int i2 = 0;
        while (i2 < 10) {
            PSGraphics2D.psSymbolNames[i2] = "plus";
            ++i2;
        }
        PSGraphics2D.psSymbolNames[0] = "vline";
        PSGraphics2D.psSymbolNames[1] = "hline";
        PSGraphics2D.psSymbolNames[2] = "plus";
        PSGraphics2D.psSymbolNames[3] = "cross";
        PSGraphics2D.psSymbolNames[4] = "star";
        PSGraphics2D.psSymbolNames[5] = "dot";
        PSGraphics2D.psSymbolNames[6] = "box";
        PSGraphics2D.psSymbolNames[7] = "triup";
        PSGraphics2D.psSymbolNames[8] = "tridn";
        PSGraphics2D.psSymbolNames[9] = "diamond";
        compositeFonts.put("SansSerif", "");
        compositeFonts.put("SansSerif-Bold", "");
        compositeFonts.put("SansSerif-Italic", "");
        compositeFonts.put("SansSerif-BoldItalic", "");
        compositeFonts.put("Serif", "");
        compositeFonts.put("Serif-Bold", "");
        compositeFonts.put("Serif-Italic", "");
        compositeFonts.put("Serif-BoldItalic", "");
        compositeFonts.put("Monospaced", "");
        compositeFonts.put("Monospaced-Bold", "");
        compositeFonts.put("Monospaced-Italic", "");
        compositeFonts.put("Monospaced-BoldItalic", "");
        compositeFonts.put("Dialog", "");
        compositeFonts.put("Dialog-Bold", "");
        compositeFonts.put("Dialog-Italic", "");
        compositeFonts.put("Dialog-BoldItalic", "");
        compositeFonts.put("DialogInput", "");
        compositeFonts.put("DialogInput-Bold", "");
        compositeFonts.put("DialogInput-Italic", "");
        compositeFonts.put("DialogInput-BoldItalic", "");
        compositeFonts.put("Typewriter", "");
        compositeFonts.put("Typewriter-Bold", "");
        compositeFonts.put("Typewriter-Italic", "");
        compositeFonts.put("Typewriter-BoldItalic", "");
        psAlignments = new String[4][4];
        i2 = 0;
        while (i2 < 4) {
            int j2 = 0;
            while (j2 < 4) {
                PSGraphics2D.psAlignments[i2][j2] = "0";
                ++j2;
            }
            ++i2;
        }
        PSGraphics2D.psAlignments[1][1] = "0";
        PSGraphics2D.psAlignments[1][2] = "1";
        PSGraphics2D.psAlignments[1][0] = "2";
        PSGraphics2D.psAlignments[1][3] = "3";
        PSGraphics2D.psAlignments[3][1] = "4";
        PSGraphics2D.psAlignments[3][2] = "5";
        PSGraphics2D.psAlignments[3][0] = "6";
        PSGraphics2D.psAlignments[3][3] = "7";
        PSGraphics2D.psAlignments[2][1] = "8";
        PSGraphics2D.psAlignments[2][2] = "9";
        PSGraphics2D.psAlignments[2][0] = "10";
        PSGraphics2D.psAlignments[2][3] = "11";
    }
}

