/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.ppm;

import java.awt.Image;
import java.awt.image.ImageProducer;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.freehep.graphicsio.ppm.ImageEncoder;

public class PPMEncoder
extends ImageEncoder {
    private List comments = new ArrayList();

    public PPMEncoder(Image img, OutputStream out) throws IOException {
        super(img, (DataOutput)new DataOutputStream(out));
    }

    public PPMEncoder(Image img, DataOutput dos) throws IOException {
        super(img, dos);
    }

    public PPMEncoder(ImageProducer prod, OutputStream out) throws IOException {
        super(prod, (DataOutput)new DataOutputStream(out));
    }

    public PPMEncoder(ImageProducer prod, DataOutput dos) throws IOException {
        super(prod, dos);
    }

    public void addComment(String comment) {
        this.comments.add(comment);
    }

    protected void encodeStart(int width, int height) throws IOException {
        this.writeString("P6\n");
        Iterator i2 = this.comments.iterator();
        while (i2.hasNext()) {
            String comment = (String)i2.next();
            this.writeString("# " + comment + "\n");
        }
        this.writeString(width + " " + height + "\n");
        this.writeString("255\n");
    }

    void writeString(String str) throws IOException {
        byte[] buf = str.getBytes();
        this.out.write(buf);
    }

    protected void encodePixels(int x2, int y2, int w2, int h2, int[] rgbPixels, int off, int scansize) throws IOException {
        byte[] ppmPixels = new byte[w2 * 3];
        int row = 0;
        while (row < h2) {
            int rowOff = off + row * scansize;
            int col = 0;
            while (col < w2) {
                int i2 = rowOff + col;
                int j2 = col * 3;
                ppmPixels[j2] = (byte)((rgbPixels[i2] & 0xFF0000) >> 16);
                ppmPixels[j2 + 1] = (byte)((rgbPixels[i2] & 0xFF00) >> 8);
                ppmPixels[j2 + 2] = (byte)(rgbPixels[i2] & 0xFF);
                ++col;
            }
            this.out.write(ppmPixels);
            ++row;
        }
    }

    protected void encodeDone() throws IOException {
    }
}

