/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.freehep.graphicsio.pdf.PDFDictionary;
import org.freehep.graphicsio.pdf.PDFFontEmbedder;
import org.freehep.graphicsio.pdf.PDFRedundanceTracker;
import org.freehep.graphicsio.pdf.PDFStream;
import org.freehep.graphicsio.pdf.PDFWriter;

public class PDFFontEmbedderType3
extends PDFFontEmbedder {
    public PDFFontEmbedderType3(FontRenderContext context, PDFWriter pdf, String reference, PDFRedundanceTracker tracker) {
        super(context, pdf, reference, tracker);
    }

    protected String getSubtype() {
        return "Type3";
    }

    protected void addAdditionalEntries(PDFDictionary fontDict) throws IOException {
        Rectangle2D boundingBox = this.getFontBBox();
        double llx = boundingBox.getX();
        double lly = boundingBox.getY();
        double urx = boundingBox.getX() + boundingBox.getWidth();
        double ury = boundingBox.getY() + boundingBox.getHeight();
        fontDict.entry("FontBBox", new double[]{llx, lly, urx, ury});
        fontDict.entry("FontMatrix", new double[]{0.001, 0.0, 0.0, 0.001, 0.0, 0.0});
        fontDict.entry("CharProcs", this.pdf.ref(this.getReference() + "CharProcs"));
        PDFDictionary resources = fontDict.openDictionary("Resources");
        resources.entry("ProcSet", new Object[]{this.pdf.name("PDF")});
        fontDict.close(resources);
    }

    protected void addAdditionalInitDicts() throws IOException {
        PDFDictionary charProcs = this.pdf.openDictionary(this.getReference() + "CharProcs");
        int i2 = 0;
        while (i2 < 256) {
            String charName = this.getEncodingTable().toName(i2);
            if (charName != null) {
                charProcs.entry(charName, this.pdf.ref(this.createCharacterReference(charName)));
            }
            ++i2;
        }
        charProcs.entry(".notdef", this.pdf.ref(this.createCharacterReference(".notdef")));
        this.pdf.close(charProcs);
    }

    protected void writeGlyph(String characterName, Shape glyph, GlyphMetrics glyphMetrics) throws IOException {
        PDFStream glyphStream = this.pdf.openStream(this.createCharacterReference(characterName), new String[]{"Flate", "ASCII85"});
        Rectangle2D bounds = glyphMetrics != null ? glyphMetrics.getBounds2D() : glyph.getBounds2D();
        double advance = glyphMetrics != null ? (double)glyphMetrics.getAdvance() : this.getUndefinedWidth();
        glyphStream.glyph(advance, 0.0, bounds.getX(), bounds.getY(), bounds.getX() + bounds.getWidth(), bounds.getY() + bounds.getHeight());
        boolean windingRule = glyphStream.drawPath(glyph);
        if (windingRule) {
            glyphStream.fillEvenOdd();
        } else {
            glyphStream.fill();
        }
        this.pdf.close(glyphStream);
    }
}

