/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.io.IOException;
import org.freehep.graphicsio.font.encoding.CharTable;
import org.freehep.graphicsio.pdf.PDFDictionary;
import org.freehep.graphicsio.pdf.PDFRedundanceTracker;
import org.freehep.graphicsio.pdf.PDFRef;
import org.freehep.graphicsio.pdf.PDFWriter;

public class PDFCharTableWriter
implements PDFRedundanceTracker.Writer {
    private static PDFCharTableWriter ctw;

    public static PDFCharTableWriter getInstance() {
        if (ctw == null) {
            ctw = new PDFCharTableWriter();
        }
        return ctw;
    }

    public void writeObject(Object object, PDFRef ref, PDFWriter pdf) throws IOException {
        CharTable charTable = (CharTable)object;
        PDFDictionary encoding = pdf.openDictionary(ref.getName());
        encoding.entry("Type", pdf.name("Encoding"));
        Object[] differences = new Object[257];
        differences[0] = new Integer(0);
        int i2 = 0;
        while (i2 < 256) {
            String charName = charTable.toName(i2);
            differences[i2 + 1] = charName != null ? pdf.name(charName) : pdf.name(".notdef");
            ++i2;
        }
        encoding.entry("Differences", differences);
        pdf.close(encoding);
    }
}

