/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.cgm;

import java.io.IOException;
import org.freehep.graphicsio.cgm.CGMOutputStream;
import org.freehep.graphicsio.cgm.CGMTag;
import org.freehep.graphicsio.cgm.CGMWriter;

public class TextAlignment
extends CGMTag {
    public static final int NORMAL_HORIZONTAL = 0;
    public static final int LEFT = 1;
    public static final int CENTRE = 2;
    public static final int RIGHT = 3;
    public static final int CONTINUOUS_HORIZONTAL = 4;
    public static final int NORMAL_VERTICAL = 0;
    public static final int TOP = 1;
    public static final int CAP = 2;
    public static final int HALF = 3;
    public static final int BASE = 4;
    public static final int BOTTOM = 5;
    public static final int CONTINUOUS_VERTICAL = 6;
    private int horizontalType;
    private int verticalType;
    private double horizontal;
    private double vertical;

    public TextAlignment() {
        super(5, 18, 1);
    }

    public TextAlignment(int horizontalType, int verticalType, double horizontal, double vertical) {
        this();
        this.horizontalType = horizontalType;
        this.verticalType = verticalType;
        this.horizontal = horizontal;
        this.vertical = vertical;
    }

    public void write(int tagID, CGMOutputStream cgm) throws IOException {
        cgm.writeEnumerate(this.horizontalType);
        cgm.writeEnumerate(this.verticalType);
        cgm.writeReal(this.horizontal);
        cgm.writeReal(this.vertical);
    }

    public void write(int tagID, CGMWriter cgm) throws IOException {
        cgm.print("TEXTALIGN ");
        switch (this.horizontalType) {
            default: {
                cgm.print("NORHORIZ");
                break;
            }
            case 1: {
                cgm.print("LEFT");
                break;
            }
            case 2: {
                cgm.print("CTR");
                break;
            }
            case 3: {
                cgm.print("RIGHT");
                break;
            }
            case 4: {
                cgm.print("CONTHORIZ");
            }
        }
        cgm.print(", ");
        switch (this.verticalType) {
            default: {
                cgm.print("NORMVERT");
                break;
            }
            case 1: {
                cgm.print("TOP");
                break;
            }
            case 2: {
                cgm.print("CAP");
                break;
            }
            case 3: {
                cgm.print("HALF");
                break;
            }
            case 4: {
                cgm.print("BASE");
                break;
            }
            case 5: {
                cgm.print("BOTTOM");
                break;
            }
            case 6: {
                cgm.print("CONTVERT");
            }
        }
        cgm.print(", ");
        cgm.writeReal(this.horizontal);
        cgm.print(", ");
        cgm.writeReal(this.vertical);
    }
}

