/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.mdi;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import org.freehep.application.HasPopupItems;
import org.freehep.swing.layout.ToolBarLayout;

public class ToolBarHolder
extends JPanel
implements HasPopupItems {
    private static final String nameKey = "nameKey";
    private static final String modeKey = "modekey";
    private HashMap toolbars = new HashMap();
    private HashMap autos = new HashMap();

    protected ToolBarHolder() {
        super(new ToolBarLayout(0, 5, 5));
    }

    void add(JToolBar bar, String name, int mode) {
        if (!this.toolbars.containsKey(name)) {
            if (mode == 0) {
                mode = 3;
            }
            if (mode == 3) {
                this.addAuto(bar);
            } else {
                bar.setVisible(mode == 2);
            }
            bar.putClientProperty(modeKey, new Integer(mode));
            bar.putClientProperty(nameKey, name);
            this.toolbars.put(name, bar);
            this.add(bar);
        }
    }

    void save(Properties props) {
        Iterator i2 = this.toolbars.values().iterator();
        while (i2.hasNext()) {
            JToolBar bar = (JToolBar)i2.next();
            props.setProperty("ToolBar." + bar.getClientProperty(nameKey).toString(), bar.getClientProperty(modeKey).toString());
        }
    }

    void remove(JToolBar bar) {
        this.toolbars.remove(bar);
        this.removeAuto(bar);
        this.remove(bar);
    }

    public JPopupMenu modifyPopupMenu(JPopupMenu popup, Component src, Point p2) {
        int i2 = 0;
        while (i2 < this.getComponentCount()) {
            final JToolBar bar = (JToolBar)this.getComponent(i2);
            String name = (String)bar.getClientProperty(nameKey);
            int mode = (Integer)bar.getClientProperty(modeKey);
            if (mode != 4) {
                JMenu menu = new JMenu(name);
                final JRadioButtonMenuItem show = new JRadioButtonMenuItem("Show");
                final JRadioButtonMenuItem hide = new JRadioButtonMenuItem("Hide");
                final JRadioButtonMenuItem auto = new JRadioButtonMenuItem("Auto");
                show.setSelected(mode == 2);
                hide.setSelected(mode == 1);
                auto.setSelected(mode == 3);
                ActionListener al = new ActionListener(){

                    public void actionPerformed(ActionEvent e2) {
                        Object source = e2.getSource();
                        if (source == hide) {
                            bar.putClientProperty(ToolBarHolder.modeKey, new Integer(1));
                            bar.setVisible(false);
                            ToolBarHolder.this.removeAuto(bar);
                        } else if (source == show) {
                            bar.putClientProperty(ToolBarHolder.modeKey, new Integer(2));
                            bar.setVisible(true);
                            ToolBarHolder.this.removeAuto(bar);
                        } else if (source == auto) {
                            bar.putClientProperty(ToolBarHolder.modeKey, new Integer(3));
                            ToolBarHolder.this.addAuto(bar);
                        }
                    }
                };
                show.addActionListener(al);
                hide.addActionListener(al);
                auto.addActionListener(al);
                menu.add(show);
                menu.add(hide);
                menu.add(auto);
                popup.add(menu);
            }
            ++i2;
        }
        return popup;
    }

    private void addAuto(JToolBar bar) {
        this.autos.put(bar, new AutoToolbarListener(bar));
    }

    private void removeAuto(JToolBar bar) {
        AutoToolbarListener l2 = (AutoToolbarListener)this.autos.remove(bar);
        if (l2 != null) {
            l2.dispose();
        }
    }

    private class AutoToolbarListener
    implements PropertyChangeListener {
        private JToolBar bar;
        int count = 0;

        AutoToolbarListener(JToolBar bar) {
            this.bar = bar;
            int n2 = bar.getComponentCount();
            boolean visible = false;
            int i2 = 0;
            while (i2 < n2) {
                Component c2 = bar.getComponent(i2);
                if (c2.isEnabled()) {
                    ++this.count;
                }
                c2.addPropertyChangeListener("enabled", this);
                ++i2;
            }
            bar.setVisible(this.count > 0);
        }

        void dispose() {
            int n2 = this.bar.getComponentCount();
            int i2 = 0;
            while (i2 < n2) {
                Component c2 = this.bar.getComponent(i2);
                c2.removePropertyChangeListener("enabled", this);
                ++i2;
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Component source = (Component)evt.getSource();
            this.count = source.isEnabled() ? ++this.count : --this.count;
            this.bar.setVisible(this.count > 0);
        }
    }
}

