/*
 * Decompiled with CFR 0.152.
 */
package painter;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import javax.swing.JPanel;

public class PText {
    protected JPanel canvas;
    protected int w;
    protected int h;

    public PText(JPanel jPanel, int n, int n2) {
        this.canvas = jPanel;
        this.w = n;
        this.h = n2;
    }

    public void drawFontShape(Graphics2D graphics2D, Shape shape, Color color) {
        graphics2D.setColor(color);
        graphics2D.draw(shape);
    }

    public void fillAndDraw(Graphics2D graphics2D, Shape shape, Color color, Color color2, Stroke stroke) {
        graphics2D.setColor(color);
        graphics2D.fill(shape);
        graphics2D.setStroke(stroke);
        graphics2D.setColor(color2);
        graphics2D.draw(shape);
    }

    public void fillFontShape(Graphics2D graphics2D, Shape shape, Color color) {
        graphics2D.setColor(color);
        graphics2D.fill(shape);
    }

    public void fillFontWithImage(Graphics2D graphics2D, Shape shape, Image image, Color color) {
        if (image == null) {
            return;
        }
        Rectangle rectangle = shape.getBounds();
        if (color != null) {
            graphics2D.setColor(color);
            graphics2D.draw(shape);
        }
        graphics2D.setClip(shape);
        graphics2D.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.canvas);
    }

    public void fillTextureShape(Graphics2D graphics2D, Shape shape, Paint paint, Stroke stroke, Color color) {
        graphics2D.setPaint(paint);
        graphics2D.fill(shape);
        graphics2D.setStroke(stroke);
        graphics2D.setColor(color);
        graphics2D.draw(shape);
    }

    public void gradientPaint(Graphics2D graphics2D, Shape shape, Color color, Color color2) {
        Rectangle rectangle = shape.getBounds();
        float f = (float)rectangle.getY();
        float f2 = (float)((double)f + rectangle.getHeight());
        GradientPaint gradientPaint = new GradientPaint(this.w / 2, f, color, this.w / 2, f2, color2);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fill(shape);
    }
}

