#include <stdio.h>
#include <string.h>
#define ENC(c) ((c) ? ((c) & 077) + ' ': '`')

static void uuencode (FILE *f,char *nom) 
{
  int ch, n,idx,count;
  register char *p;
  char buf[80],outbuf[250];
  FILE *in;

  in = fopen(nom,"rb");
  if (in == NULL) return;
  p = strrchr(nom,'\\');
  if (p) p++;
  else p = nom;
  fprintf(f,"\r\nbegin 0666 %s\r\n",p); 
  while ((n = fread (buf, 1, 45, in)) != 0)
        {
      idx = 0;
          ch = ENC (n);
      outbuf[idx++] = ch;
          for (p = buf; n > 0; n -= 3, p += 3)
        {
          ch = *p >> 2;
          ch = ENC (ch);
      outbuf[idx++] = ch;
          ch = ((*p << 4) & 060) | ((p[1] >> 4) & 017); 
          ch = ENC (ch);
          outbuf[idx++] = ch;

          ch = ((p[1] << 2) & 074) | ((p[2] >> 6) & 03); 
          ch = ENC (ch);
          outbuf[idx++] = ch;

          ch = p[2] & 077;
          ch = ENC (ch);
          outbuf[idx++] = ch;
        }
        outbuf[idx++] = '\r';
        outbuf[idx++] = '\n';
    outbuf[idx] = 0;
        count =  fwrite(outbuf, 1,idx,f);
        if (count != idx) break;
        }
  fprintf(f,"%c\r\nend\r\n",ENC(0));
  fclose(in);
}

int main(int argc,char *argv[])
{
        FILE *f;

        if (argc <= 2) {
                printf("Usage %s <input file> <encoded output file>\n",argv[0]); 
                return(1);
        }
        f = fopen(argv[2],"wb");
        if (f == NULL) {
                printf("Impossible to open %s\n",argv[2]); 
                return(1);
        }
        uuencode(f,argv[1]);
        fclose(f);
        printf("Result encoded in %s\n",argv[2]); 
        return(0);
}