/*
* This file is released into the Public Domain.
* M Carter  18-nov-2000 Begin
*/

#include <stdio.h>
#include <stdlib.h>
//#include <malloc.h>
#include <string.h>

void process_args(int argc, char *argv[]);

size_t buffer_size = 1440000L;
char *buffer;

/*
 * split file
 */
int split(char *file_name)
{
  FILE *fp_in;
  FILE  *fp_out;
  int file_error;
  int bytes_read;
  char msg[1000];
  char out_file_name[1000];
  int file_number =0;

  /* open file for reading */
  fp_in = fopen(file_name, "rb");
  if(!fp_in)
    {
      fprintf(stderr,"Error: Couldn't open %s\n",file_name);
      return EXIT_FAILURE;
    }

  /* loop over input file */
  while(1)
  {
	bytes_read = fread(buffer,1,buffer_size, fp_in);

	/* check for errors */      
	file_error = ferror(fp_in);
    if(file_error)
	{
		sprintf(msg,"Error: %s",file_name);
		perror(msg);
		return EXIT_FAILURE;
	}

    /* exit if nothing to write */
    if(bytes_read<=0) break;

    /* create a file for writing */
    file_number++;
    sprintf(out_file_name,"%s.%03d", file_name, file_number);
    fp_out = fopen(out_file_name, "wb");
    if(!fp_out)
	{
		fprintf(stderr,"Error: Couldn't write to file %s\n", out_file_name);
		return EXIT_FAILURE;
	}
    printf("Writing file %s\n",out_file_name);

    /* write to file */
    fwrite(buffer, 1, bytes_read, fp_out);
    if(ferror(fp_out))
	{
		sprintf(msg,"Error: %s", out_file_name);
		perror(msg);
		return EXIT_FAILURE;
	}

	fclose(fp_out);
  }
}


/*
 * main
 */
int main(int argc, char *argv[])
{
	buffer = (char *) malloc(buffer_size);
	if(!buffer)
	{
		fprintf(stderr, "Couldn't allocate memory\n");
		return EXIT_FAILURE;
	}

	process_args(argc, argv);

	free(buffer);

	return EXIT_SUCCESS;
}

/*
* process arguments 
*/

void process_args(int argc, char *argv[])
{
  int arg_num;
  char *arg;
  if(1 == argc)
    {
      fprintf(stderr,"No arguments. Try %s --help\n", argv[0]);
    }


  for(arg_num = 1; arg_num<argc; arg_num++)
  {
      arg = argv[arg_num];
      if(0==strcmp("-h",arg) || 0 ==strcmp("--help",arg))
	{
	  printf("Usage: %s [OPTION] ... [FILE] ...\n",argv[0]);
	  puts("Splits a long file into several shorter ones.");
	  puts(""); 
	  puts("-h, --help     Display this help");
	  puts("-v, --version  Version information");
	  return;
	}
      else if(0==strcmp("-v", arg) || 0==strcmp("--version",arg))
	{
	  puts("mcsplit (MC fileutils) 0.1");
	  return;
	}
      else
	  {
	split(arg);
	  }
  }


}
