/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.DTreeNode;
import common.DTreeView;
import common.DirIcons;
import common.OS;
import common.Path;
import common.Preferences;
import common.VectorString;
import java.awt.Cursor;
import java.awt.Dimension;
import java.io.File;

public class TreeDir
extends DTreeView {
    static String letters = "abcdefghijklmnopqrstuvwxyz";
    static VectorString Disks = new VectorString();
    static int maxUnits = 0;

    public TreeDir() {
    }

    public TreeDir(VectorString vectorString) {
        this();
        Disks = vectorString;
    }

    static void setDisks(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            Disks.addElement(stringArray[i]);
        }
    }

    void driveIdent() {
        if (OS.isWindows()) {
            int n = 0;
            int n2 = letters.length();
            maxUnits = 0;
            Disks.clear();
            if (!Preferences.FLOPPIES) {
                n = 2;
                n2 -= n;
            }
            while (n < n2) {
                char c = letters.charAt(n);
                String string = String.valueOf(String.valueOf(c)).concat(":");
                File file = new File(String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(File.separatorChar))));
                if (file.exists()) {
                    Disks.addElement(string);
                    ++maxUnits;
                }
                ++n;
            }
        }
    }

    void setSub(DTreeNode dTreeNode, String string) {
        String[] stringArray = new File(string, File.separator).list();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!new File(string, stringArray[i]).isDirectory()) continue;
            dTreeNode.isDirectory = true;
            dTreeNode.isExpandable = true;
            return;
        }
    }

    public void init() {
        if (OS.isWindows()) {
            this.driveIdent();
            for (int i = 0; i < maxUnits; ++i) {
                String string = Disks.elementAt(i);
                DTreeNode dTreeNode = new DTreeNode(string, DirIcons.IconDrive, DirIcons.IconDrive, this);
                this.append(dTreeNode);
                this.setSub(dTreeNode, string);
            }
        } else {
            DTreeNode dTreeNode = new DTreeNode("/", this);
            this.append(dTreeNode);
            this.setSub(dTreeNode, "/");
        }
    }

    protected void complete(DTreeNode dTreeNode, int n, int n2) {
        if (!dTreeNode.isIncomplete()) {
            return;
        }
        String string = "";
        Dimension dimension = this.getSize();
        if (n == 0 && n2 == 0) {
            n = dimension.width / 3 - 64;
            n2 = dimension.height / 2 - 8;
        }
        if (n2 + 32 > dimension.height) {
            n2 -= 48;
        }
        this.setCursor(new Cursor(3));
        for (DTreeNode dTreeNode2 = dTreeNode; dTreeNode2 != null; dTreeNode2 = dTreeNode2.getParent()) {
            string = Path.merge(dTreeNode2.getText(), string);
        }
        this.makeBranch(dTreeNode, string);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void makeBranch(DTreeNode dTreeNode, String string) {
        int n = 0;
        boolean bl = true;
        string = Path.makeJavaRoot(string);
        String[] stringArray = new File(string, File.separator).list();
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string2 = stringArray[i];
            try {
                if (!new File(string, string2).isDirectory()) continue;
                DTreeNode dTreeNode2 = new DTreeNode(string2, DirIcons.IconDir, DirIcons.Expanded, this);
                if (bl) {
                    n = 0;
                    bl = false;
                } else {
                    n = 2;
                }
                this.insert(dTreeNode2, dTreeNode, n);
                this.setSub(dTreeNode2, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(File.separator).append(string2))));
                dTreeNode = dTreeNode2;
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public String getSelectedPath() {
        String string = "";
        for (DTreeNode dTreeNode = this.getSelectedNode(); dTreeNode != null; dTreeNode = dTreeNode.getParent()) {
            string = Path.merge(dTreeNode.getText(), string);
        }
        return string;
    }
}

