/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.OS;
import java.io.File;

public final class Path {
    public static String ADir;
    public static String Drive;
    public static String Dir;
    public static String Filename;
    public static String Node;
    public static String Extension;

    public static String getCurDir() {
        return System.getProperty("user.dir");
    }

    public static String getUserDir() {
        return Path.getCurDir();
    }

    public static String getCurPath() {
        return Path.getCurDir();
    }

    public static String getSysPath() {
        return Path.getCurDir();
    }

    public static String getCurDrive() {
        return Path.splitDrive(System.getProperty("user.dir"));
    }

    public static boolean hasExtension(String string) {
        return string.indexOf(46) != -1;
    }

    public static String getExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static String changeExt(String string, String string2) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(".").append(string2)));
        }
        return String.valueOf(String.valueOf(string.substring(0, n + 1))).concat(String.valueOf(String.valueOf(string2)));
    }

    public static String removeExt(String string) {
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static boolean isDrive(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return false;
        }
        if (string.endsWith(File.separator)) {
            string = Path.noSuffixed(string);
        }
        return string.charAt(1) == ':' && string.length() == 2;
    }

    public static boolean isDirectory(String string) {
        return new File(string).isDirectory();
    }

    public static String merge(String string, String string2) {
        if (string2 == null) {
            return string;
        }
        if (string == null) {
            string = "";
        }
        if (string.length() == 0) {
            return string2;
        }
        if (string.endsWith(File.separator)) {
            return String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(string2)));
        }
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(File.separator).append(string2)));
    }

    public static String pastePath(String string, String string2) {
        return Path.merge(string, string2);
    }

    public static String merge(String string, String string2, String string3) {
        if (string3 == null) {
            string3 = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string == null) {
            string = "";
        }
        if (!string.endsWith(File.separator)) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(File.separator)));
        }
        if (!string2.endsWith(File.separator)) {
            string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(File.separator)));
        }
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(string2).append(string3)));
    }

    public static String splitDrive(String string) {
        int n = string.indexOf(":");
        if (n > 0) {
            return string.substring(0, n + 1);
        }
        return "";
    }

    public static int getUnit(String string) {
        String string2 = Path.splitDrive(string).toLowerCase();
        char c = string2.charAt(0);
        return c - 97;
    }

    public static String splitFile(String string) {
        return Path.getFile(string);
    }

    public static String getFile(String string) {
        int n;
        File file = new File(string);
        if (file.isDirectory()) {
            return "";
        }
        int n2 = string.lastIndexOf(File.separator) + 1;
        int n3 = string.lastIndexOf(47) + 1;
        int n4 = n2 = (n2 = Math.max(n2, n3)) > (n = string.lastIndexOf(":") + 1) ? n2 : n;
        if (n2 > 0) {
            return string.substring(n2);
        }
        return string;
    }

    public static String splitLast(String string) {
        int n;
        int n2 = string.lastIndexOf(File.separator) + 1;
        n2 = n2 > (n = string.lastIndexOf(":") + 1) ? n2 : n;
        String string2 = n2 > 0 ? string.substring(n2) : string;
        if (string2.equals(File.separator)) {
            string2 = "";
        }
        return string2;
    }

    public static void split(String string) {
        int n;
        int n2 = string.length();
        int n3 = string.indexOf(":");
        if (n3 > 0) {
            Drive = string.substring(0, ++n3);
        } else {
            n3 = 0;
            Drive = "";
        }
        if (string.charAt(n3) == File.separatorChar) {
            ++n3;
        }
        if ((n = string.lastIndexOf(File.separatorChar)) > n3) {
            Dir = string.substring(n3, n);
            Filename = string.substring(n + 1, n2);
        } else {
            Dir = "";
            Filename = string.substring(n3, n2);
        }
        n = Filename.indexOf(46);
        if (n == -1) {
            Node = Filename;
            Extension = "";
        } else {
            Node = Filename.substring(0, n);
            Extension = Filename.substring(n + 1);
        }
        ADir = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Drive))).append(File.separator).append(Dir)));
    }

    public static String splitNode(String string) {
        return Path.getNode(string);
    }

    public static String getNode(String string) {
        int n;
        int n2 = string.lastIndexOf(File.separatorChar);
        if (n2 != -1) {
            string = string.substring(n2 + 1);
        }
        if ((n = string.lastIndexOf(46)) != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static String splitRelativePath(String string) {
        return Path.getRelativePath(string);
    }

    public static String getRelativePath(String string) {
        int n = string.lastIndexOf(":");
        n = n > 0 ? ++n : 0;
        if (string.charAt(n) == File.separatorChar) {
            ++n;
        }
        return string.substring(n);
    }

    public static String splitPath(String string) {
        return Path.getPath(string);
    }

    public static String getPath(String string) {
        File file;
        if (string.endsWith(File.separator)) {
            return Path.noSuffixed(string);
        }
        int n = string.lastIndexOf(File.separator);
        int n2 = string.lastIndexOf(42);
        if (n2 == -1 && (file = new File(string)).isDirectory()) {
            return string;
        }
        if (n > 0) {
            return string.substring(0, n);
        }
        n = string.indexOf(":");
        if (n > 0) {
            return string.substring(0, n + 1);
        }
        return "";
    }

    public static String makeWinRoot(String string) {
        if (OS.isWindows() && string.endsWith(":")) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(File.separator)));
        }
        return string;
    }

    public static String makeJavaRoot(String string) {
        if (string.endsWith(File.separator)) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String noSuffixed(String string) {
        if (!string.endsWith(File.separator)) {
            return string;
        }
        return string.substring(0, string.length() - 1);
    }

    public static String suffixed(String string) {
        if (string.endsWith(File.separator)) {
            return string;
        }
        return String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(File.separator)));
    }

    public static String setCanonical(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c != '\\' && c != '/') continue;
            cArray[i] = c = File.separatorChar;
        }
        while (cArray[n - 1] == File.separatorChar) {
            --n;
        }
        return new String(cArray, 0, n);
    }

    public static boolean isValidDrive(String string) {
        if (string.charAt(1) != ':') {
            return false;
        }
        if (string.length() > 2) {
            return false;
        }
        return Character.isLetter(string.charAt(0));
    }

    public static boolean equals(String string, String string2) {
        if (OS.isWindows()) {
            return string.equalsIgnoreCase(string2);
        }
        return string.equals(string2);
    }

    public static boolean sameVersion(String string, String string2) {
        File file = new File(string);
        File file2 = new File(string2);
        return file.length() == file2.length() && file.lastModified() == file2.lastModified();
    }

    public static boolean newVersion(String string, String string2) {
        File file = new File(string);
        File file2 = new File(string2);
        return file.lastModified() > file2.lastModified();
    }
}

