/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.loops;

import java.awt.Color;
import sun.java2d.loops.DrawLine;
import sun.java2d.loops.DrawPolygons;
import sun.java2d.loops.DrawRect;
import sun.java2d.loops.FillPolygons;
import sun.java2d.loops.FillRect;
import sun.java2d.loops.FillSpans;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.GraphicsPrimitiveProxy;
import sun.java2d.loops.GraphicsPrimitives;
import sun.java2d.pipe.SpanIterator;

public final class ShortDiscreteRenderer
implements GraphicsPrimitives {
    static int[] ST_SHORT_555_RGB = new int[]{9};
    static int[] ST_SHORT_565_RGB = new int[]{8};
    static int[] ST_USHORT_GRAY = new int[]{11};

    public final GraphicsPrimitive[] getPrimitives() {
        GraphicsPrimitive[] graphicsPrimitiveArray = new GraphicsPrimitive[]{new GraphicsPrimitiveProxy(this, "FillRectS555", ST_SHORT_555_RGB, FillRect.getMethodSignature()), new GraphicsPrimitiveProxy(this, "FillRectS565", ST_SHORT_565_RGB, FillRect.getMethodSignature()), new GraphicsPrimitiveProxy(this, "FillRectGray16", ST_USHORT_GRAY, FillRect.getMethodSignature()), new GraphicsPrimitiveProxy(this, "FillSpansS555", ST_SHORT_555_RGB, FillSpans.getMethodSignature()), new GraphicsPrimitiveProxy(this, "FillSpansS565", ST_SHORT_565_RGB, FillSpans.getMethodSignature()), new GraphicsPrimitiveProxy(this, "FillSpansGray16", ST_USHORT_GRAY, FillSpans.getMethodSignature()), new GraphicsPrimitiveProxy(this, "DrawLineS555", ST_SHORT_555_RGB, DrawLine.getMethodSignature()), new GraphicsPrimitiveProxy(this, "DrawLineS565", ST_SHORT_565_RGB, DrawLine.getMethodSignature()), new GraphicsPrimitiveProxy(this, "DrawLineGray16", ST_USHORT_GRAY, DrawLine.getMethodSignature()), new GraphicsPrimitiveProxy(this, "FillPolygonsS555", ST_SHORT_555_RGB, FillPolygons.getMethodSignature()), new GraphicsPrimitiveProxy(this, "FillPolygonsS565", ST_SHORT_565_RGB, FillPolygons.getMethodSignature()), new GraphicsPrimitiveProxy(this, "FillPolygonsGray16", ST_USHORT_GRAY, FillPolygons.getMethodSignature()), new GraphicsPrimitiveProxy(this, "DrawPolygonsS555", ST_SHORT_555_RGB, DrawPolygons.getMethodSignature()), new GraphicsPrimitiveProxy(this, "DrawPolygonsS565", ST_SHORT_565_RGB, DrawPolygons.getMethodSignature()), new GraphicsPrimitiveProxy(this, "DrawPolygonsGray16", ST_USHORT_GRAY, DrawPolygons.getMethodSignature()), new GraphicsPrimitiveProxy(this, "DrawRectS555", ST_SHORT_555_RGB, DrawRect.getMethodSignature()), new GraphicsPrimitiveProxy(this, "DrawRectS565", ST_SHORT_565_RGB, DrawRect.getMethodSignature()), new GraphicsPrimitiveProxy(this, "DrawRectGray16", ST_USHORT_GRAY, DrawRect.getMethodSignature())};
        return graphicsPrimitiveArray;
    }

    static int toS555(Color color) {
        int n = color.getRGB();
        int n2 = n >> 19 & 0x1F;
        int n3 = n >> 11 & 0x1F;
        int n4 = n >> 3 & 0x1F;
        return n2 << 10 | n3 << 5 | n4;
    }

    static int toS565(Color color) {
        int n = color.getRGB();
        int n2 = n >> 19 & 0x1F;
        int n3 = n >> 10 & 0x3F;
        int n4 = n >> 3 & 0x1F;
        return n2 << 11 | n3 << 5 | n4;
    }

    static int toGray16(Color color) {
        int n = color.getRGB();
        int n2 = n >> 16 & 0xFF;
        n2 += n2 << 8;
        int n3 = n >> 8 & 0xFF;
        n3 += n3 << 8;
        int n4 = n & 0xFF;
        n4 += n4 << 8;
        return (int)((double)n2 * 0.299 + (double)n3 * 0.587 + (double)n4 * 0.114);
    }

    static native void devSetRect(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, short[] var10, int var11, int var12);

    static native void devSetSpans(int var0, SpanIterator var1, long var2, int var4, short[] var5, int var6, int var7);

    static native void devDrawLine(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, short[] var10, int var11, int var12);

    static native void devFillPolygons(int var0, int[] var1, int[] var2, int[] var3, int var4, boolean var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, short[] var13, int var14, int var15);

    static native void devDrawPolygons(int var0, int[] var1, int[] var2, int[] var3, int var4, boolean var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, short[] var13, int var14, int var15);

    static native void devDrawRect(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, short[] var10, int var11, int var12);
}

