/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import java.security.AccessController;
import java.security.CodeSource;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import sun.plugin.security.TrustDeciderDialog;

class TrustDecider {
    TrustDecider() {
    }

    public static boolean isAllPermissionGranted(CodeSource codeSource) throws CertificateEncodingException {
        Certificate[] certificateArray = codeSource.getCertificates();
        String string = codeSource.getLocation().toString();
        if (certificateArray == null) {
            return TrustDecider.isAllPermissionGranted(codeSource, string, null, null, 0);
        }
        int n = 0;
        int n2 = 0;
        while (n2 < certificateArray.length) {
            byte[][] byArray;
            int n3 = n;
            while (n3 + 1 < certificateArray.length) {
                if (!(certificateArray[n3] instanceof X509Certificate) || !(certificateArray[n3 + 1] instanceof X509Certificate) || !TrustDecider.isIssuerOf((X509Certificate)certificateArray[n3], (X509Certificate)certificateArray[n3 + 1])) break;
                ++n3;
            }
            if ((byArray = TrustDecider.makeChain(certificateArray, n, n2 = n3 + 1)) != null) {
                int[] nArray = new int[byArray.length];
                int n4 = 0;
                while (n4 < byArray.length) {
                    nArray[n4] = byArray[n4].length;
                    ++n4;
                }
                if (TrustDecider.isAllPermissionGranted(codeSource, string, byArray, nArray, byArray.length)) {
                    return true;
                }
            }
            n = n2;
        }
        return false;
    }

    private static native boolean isAllPermissionGranted(CodeSource var0, String var1, byte[][] var2, int[] var3, int var4);

    private static byte[][] makeChain(Certificate[] certificateArray, int n, int n2) throws CertificateEncodingException {
        if (n == n2) {
            return null;
        }
        byte[][] byArrayArray = new byte[n2 - n][];
        int n3 = n;
        while (n3 < n2) {
            byArrayArray[n3 - n] = certificateArray[n3].getEncoded();
            ++n3;
        }
        return byArrayArray;
    }

    private static boolean isIssuerOf(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        Principal principal;
        Principal principal2 = x509Certificate.getIssuerDN();
        return principal2.equals(principal = x509Certificate2.getSubjectDN());
    }

    static int showSecurityDialog(CodeSource codeSource) throws Exception {
        Integer n = (Integer)AccessController.doPrivileged(new PrivilegedBlockAction(codeSource));
        int n2 = 2;
        if (n != null) {
            n2 = n;
        }
        return n2;
    }

    private static class PrivilegedBlockAction
    implements PrivilegedExceptionAction {
        Certificate[] certs;

        PrivilegedBlockAction(CodeSource codeSource) {
            this.certs = codeSource.getCertificates();
        }

        public Object run() throws Exception {
            TrustDeciderDialog trustDeciderDialog = new TrustDeciderDialog(this.certs);
            return new Integer(trustDeciderDialog.DoModal());
        }
    }
}

