/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.iap;

import com.sun.mail.iap.ByteArray;
import com.sun.mail.iap.Protocol;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.util.ASCIIUtility;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Vector;

public class Response {
    protected int index;
    protected int size;
    protected byte[] buffer;
    protected int type;
    protected String tag;
    private static final int increment = 100;
    public static final int TAG_MASK = 3;
    public static final int CONTINUATION = 1;
    public static final int TAGGED = 2;
    public static final int UNTAGGED = 3;
    public static final int TYPE_MASK = 28;
    public static final int OK = 4;
    public static final int NO = 8;
    public static final int BAD = 10;
    public static final int BYE = 16;
    public static Response ByeResponse = new Response("* BYE Connection down");

    public Response(String string) {
        this.buffer = ASCIIUtility.getBytes(string);
        this.size = this.buffer.length;
        this.parse();
    }

    public Response(Protocol protocol) throws IOException, ProtocolException {
        ByteArray byteArray = protocol.getInputStream().readResponse();
        this.buffer = byteArray.getBytes();
        this.size = byteArray.getCount() - 2;
        this.parse();
    }

    public Response(Response response) {
        this.index = response.index;
        this.size = response.size;
        this.buffer = response.buffer;
        this.type = response.type;
        this.tag = response.tag;
    }

    private void parse() {
        this.index = 0;
        if (this.buffer[this.index] == 43) {
            this.type |= 1;
            ++this.index;
            return;
        }
        if (this.buffer[this.index] == 42) {
            this.type |= 3;
            ++this.index;
        } else {
            this.type |= 2;
            this.tag = this.readAtom();
        }
        int n = this.index;
        String string = this.readAtom();
        if (string.equalsIgnoreCase("OK")) {
            this.type |= 4;
            return;
        }
        if (string.equalsIgnoreCase("NO")) {
            this.type |= 8;
            return;
        }
        if (string.equalsIgnoreCase("BAD")) {
            this.type |= 0xA;
            return;
        }
        if (string.equalsIgnoreCase("BYE")) {
            this.type |= 0x10;
            return;
        }
        this.index = n;
    }

    public void skipSpaces() {
        while (this.index < this.size && this.buffer[this.index] == 32) {
            ++this.index;
        }
    }

    public void skip(int n) {
        this.index += n;
    }

    public byte peekByte() {
        return this.buffer[this.index];
    }

    public byte readByte() {
        return this.buffer[this.index++];
    }

    public String readAtom() {
        byte by;
        this.skipSpaces();
        if (this.index >= this.size) {
            return null;
        }
        int n = this.index;
        while (this.index < this.size && (by = this.buffer[this.index]) > 32 && by != 40 && by != 41 && by != 37 && by != 42 && by != 34 && by != 92 && by != 127) {
            ++this.index;
        }
        return ASCIIUtility.toString(this.buffer, n, this.index);
    }

    public String[] readStringList() {
        this.skipSpaces();
        if (this.buffer[this.index] != 40) {
            return null;
        }
        ++this.index;
        Vector<String> vector = new Vector<String>();
        do {
            vector.addElement(this.readString());
        } while (this.buffer[this.index++] != 41);
        int n = vector.size();
        if (n > 0) {
            Object[] objectArray = new String[n];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public int readNumber() {
        this.skipSpaces();
        int n = this.index;
        while (this.index < this.size && Character.isDigit((char)this.buffer[this.index])) {
            ++this.index;
        }
        if (this.index > n) {
            try {
                return ASCIIUtility.parseInt(this.buffer, n, this.index);
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return -1;
    }

    public long readLong() {
        this.skipSpaces();
        int n = this.index;
        while (this.index < this.size && Character.isDigit((char)this.buffer[this.index])) {
            ++this.index;
        }
        if (this.index > n) {
            try {
                return ASCIIUtility.parseLong(this.buffer, n, this.index);
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return -1L;
    }

    public String readString() {
        return (String)this.parseString(false, true);
    }

    public ByteArrayInputStream readBytes() {
        ByteArray byteArray = this.readByteArray();
        if (byteArray != null) {
            return byteArray.toByteArrayInputStream();
        }
        return null;
    }

    public ByteArray readByteArray() {
        return (ByteArray)this.parseString(false, false);
    }

    public String readAtomString() {
        return (String)this.parseString(true, true);
    }

    private Object parseString(boolean bl, boolean bl2) {
        this.skipSpaces();
        byte by = this.buffer[this.index];
        if (by == 34) {
            ++this.index;
            int n = this.index;
            int n2 = this.index;
            while ((by = this.buffer[this.index]) != 34) {
                if (by == 92) {
                    ++this.index;
                }
                if (this.index != n2) {
                    this.buffer[n2] = this.buffer[this.index];
                }
                ++n2;
                ++this.index;
            }
            ++this.index;
            if (bl2) {
                return ASCIIUtility.toString(this.buffer, n, n2);
            }
            return new ByteArray(this.buffer, n, n2 - n);
        }
        if (by == 123) {
            int n = ++this.index;
            while (this.buffer[this.index] != 125) {
                ++this.index;
            }
            int n3 = 0;
            try {
                n3 = ASCIIUtility.parseInt(this.buffer, n, this.index);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            n = this.index + 3;
            this.index = n + n3;
            if (bl2) {
                return ASCIIUtility.toString(this.buffer, n, n + n3);
            }
            return new ByteArray(this.buffer, n, n3);
        }
        if (bl) {
            int n = this.index;
            String string = this.readAtom();
            if (bl2) {
                return string;
            }
            return new ByteArray(this.buffer, n, this.index);
        }
        if (by == 78 || by == 110) {
            this.index += 3;
            return null;
        }
        return null;
    }

    public int getType() {
        return this.type;
    }

    public boolean isContinuation() {
        return (this.type & 3) == 1;
    }

    public boolean isTagged() {
        return (this.type & 3) == 2;
    }

    public boolean isUnTagged() {
        return (this.type & 3) == 3;
    }

    public boolean isOK() {
        return (this.type & 0x1C) == 4;
    }

    public boolean isNO() {
        return (this.type & 0x1C) == 8;
    }

    public boolean isBAD() {
        return (this.type & 0x1C) == 10;
    }

    public boolean isBYE() {
        return (this.type & 0x1C) == 16;
    }

    public String getTag() {
        return this.tag;
    }

    public String toString() {
        return ASCIIUtility.toString(this.buffer, 0, this.size);
    }
}

