/*
 * Decompiled with CFR 0.152.
 */
package Typing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class Help
extends JFrame {
    protected JEditorPane editorPane;

    public Help() {
        super("TypingPractice Help");
        this.createUI();
        this.setVisible(false);
    }

    protected void createUI() {
        this.setSize(800, 570);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.setIconImage(toolkit.getImage(this.getClass().getResource("images/help.gif")));
        Dimension dimension = toolkit.getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        Container container = this.getContentPane();
        this.editorPane = new JEditorPane();
        this.editorPane.setEditable(false);
        container.add((Component)new JScrollPane(this.editorPane), "Center");
        try {
            this.editorPane.setPage(this.getClass().getResource("html/help.htm"));
        }
        catch (Exception exception) {
            this.editorPane.setText(exception.getMessage());
        }
        this.editorPane.addHyperlinkListener(new LinkActivator());
        this.setDefaultCloseOperation(2);
    }

    class LinkActivator
    implements HyperlinkListener {
        LinkActivator() {
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            HyperlinkEvent.EventType eventType = hyperlinkEvent.getEventType();
            if (eventType == HyperlinkEvent.EventType.ENTERED) {
                Help.this.editorPane.setCursor(Cursor.getPredefinedCursor(12));
            } else if (eventType == HyperlinkEvent.EventType.EXITED) {
                Help.this.editorPane.setCursor(Cursor.getDefaultCursor());
            } else if (eventType == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    Help.this.editorPane.setPage(hyperlinkEvent.getURL());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

