/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class GTextToken {
    private Font font;
    private Color color;
    private String text;
    private String ref;
    private Point affix;
    private Rectangle linkArea;

    public GTextToken(Graphics graphics, String string, Point point, String string2) {
        this.font = graphics.getFont();
        this.color = graphics.getColor();
        this.text = string;
        this.affix = point;
        if (string2 != null) {
            this.ref = string2;
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = (int)(0.75 * (double)fontMetrics.getAscent());
            this.linkArea = new Rectangle(point.x, point.y - n, fontMetrics.stringWidth(string), n + 2);
        }
    }

    public void print() {
        System.out.println(String.valueOf(this.font) + ", " + this.color + ", " + this.affix.x + ", " + this.affix.y);
    }

    public String getRef() {
        return this.ref;
    }

    public Rectangle getLinkArea() {
        return this.linkArea;
    }

    public void paint(Graphics graphics) {
        graphics.setFont(this.font);
        graphics.setColor(this.color);
        graphics.drawString(this.text, this.affix.x, this.affix.y);
        if (this.linkArea != null) {
            int n = 0;
            while (n < (this.font.isBold() ? 2 : 1)) {
                graphics.drawLine(this.affix.x, this.affix.y + 2 + n, this.affix.x + this.linkArea.width, this.affix.y + 2 + n);
                ++n;
            }
        }
    }
}

