/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class GSkewDialog
extends GOkCancelHelpDialog
implements ItemListener {
    public static final String SKEWXZ_ICON = "skewxz.gif";
    public static final String SKEWYZ_ICON = "skewyz.gif";
    public static final Dimension ICONDIM = new Dimension(40, 40);
    private CheckboxGroup planes;
    private Checkbox xzPlane;
    private Checkbox yzPlane;
    private TextField xzAngle;
    private TextField yzAngle;
    private boolean xzAngleGotFocus;
    private boolean yzAngleGotFocus;

    public GSkewDialog(GFrame gFrame, String string) {
        super(gFrame, "Skew");
        this.helpTopic = "skew solid";
        this.setTitle("Skew " + string);
        this.xzAngle = new TextField(3);
        this.xzAngle.setFont(gFrame.numberFont);
        this.yzAngle = new TextField(3);
        this.yzAngle.setFont(gFrame.numberFont);
        this.xzAngle.setEditable(false);
        this.planes = new CheckboxGroup();
        this.xzPlane = new Checkbox("In xz plane at", this.planes, false);
        this.xzPlane.addItemListener(this);
        this.yzPlane = new Checkbox("In yz plane at", this.planes, true);
        this.yzPlane.addItemListener(this);
        this.layComponents();
        this.pack();
        this.positionLeft();
        this.show();
    }

    private void layComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.layPanels(gridBagLayout, gridBagConstraints, true);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.top = 15;
        gridBagConstraints.gridwidth = 1;
        Image image = this.getToolkit().getImage(String.valueOf(GDialog.frame.imageDir) + "\\" + SKEWXZ_ICON);
        GIconCanvas gIconCanvas = new GIconCanvas(image, ICONDIM);
        gridBagLayout.setConstraints(gIconCanvas, gridBagConstraints);
        this.dataPanel.add(gIconCanvas);
        gridBagLayout.setConstraints(this.xzPlane, gridBagConstraints);
        this.dataPanel.add(this.xzPlane);
        gridBagConstraints.insets.left = 5;
        gridBagLayout.setConstraints(this.xzAngle, gridBagConstraints);
        ((TextComponent)this.xzAngle).setText("0");
        this.dataPanel.add(this.xzAngle);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        Label label = new Label("degrees");
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.dataPanel.add(label);
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        Image image2 = this.getToolkit().getImage(String.valueOf(GDialog.frame.imageDir) + "\\" + SKEWYZ_ICON);
        GIconCanvas gIconCanvas2 = new GIconCanvas(image2, ICONDIM);
        gridBagLayout.setConstraints(gIconCanvas2, gridBagConstraints);
        this.dataPanel.add(gIconCanvas2);
        gridBagLayout.setConstraints(this.yzPlane, gridBagConstraints);
        this.dataPanel.add(this.yzPlane);
        gridBagConstraints.insets.left = 5;
        gridBagLayout.setConstraints(this.yzAngle, gridBagConstraints);
        ((TextComponent)this.yzAngle).setText("0");
        this.dataPanel.add(this.yzAngle);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        Label label2 = new Label("degrees");
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        this.dataPanel.add(label2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.insets.bottom = 20;
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        this.buttonsPanel.add(this.okButton);
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        this.buttonsPanel.add(this.cancelButton);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 20;
        gridBagLayout.setConstraints(this.helpButton, gridBagConstraints);
        this.buttonsPanel.add(this.helpButton);
    }

    protected boolean onOk() {
        GPoint3D gPoint3D;
        try {
            gPoint3D = this.getAngles();
        }
        catch (NumberFormatException numberFormatException) {
            new GAlertDialog(GDialog.frame, "warn.gif", "Wrong Number Format", "Couldn't read angle");
            return false;
        }
        if (gPoint3D.X < 0.0 || gPoint3D.X >= 90.0 || gPoint3D.Y < 0.0 || gPoint3D.Y >= 90.0) {
            new GAlertDialog(GDialog.frame, "warn.gif", "Wrong angle value", "Angle not between 0 and 90");
            return false;
        }
        return true;
    }

    public GPoint3D getAngles() {
        GPoint3D gPoint3D = new GPoint3D();
        if (this.planes.getSelectedCheckbox() == this.xzPlane) {
            gPoint3D.X = Double.valueOf(this.xzAngle.getText());
        } else {
            gPoint3D.Y = Double.valueOf(this.yzAngle.getText());
        }
        return gPoint3D;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.xzPlane) {
            ((TextComponent)this.xzAngle).setText("");
            this.xzAngle.setEditable(true);
            ((TextComponent)this.yzAngle).setText("0");
            this.yzAngle.setEditable(false);
            this.xzAngle.requestFocus();
            return;
        }
        ((TextComponent)this.yzAngle).setText("");
        this.yzAngle.setEditable(true);
        ((TextComponent)this.xzAngle).setText("0");
        this.xzAngle.setEditable(false);
        this.yzAngle.requestFocus();
    }
}

