/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;

public class GLabelList
implements Serializable {
    protected GLabelNode head;
    protected GLabelNode tail;
    protected int dim = 0;

    public void print() {
        GLabelNode gLabelNode = this.head;
        while (gLabelNode != null) {
            System.out.println(gLabelNode.getLabel());
            gLabelNode = gLabelNode.getNext();
        }
    }

    public GLabelNode getHead() {
        return this.head;
    }

    public GLabelNode getTail() {
        return this.tail;
    }

    public int getDim() {
        return this.dim;
    }

    public void addToHead(String string) {
        GLabelNode gLabelNode = new GLabelNode(string);
        if (this.head == null) {
            this.head = this.tail = gLabelNode;
        } else {
            this.head.setPrev(gLabelNode);
            gLabelNode.setNext(this.head);
            this.head = gLabelNode;
        }
        ++this.dim;
    }

    public void addToTail(String string) {
        GLabelNode gLabelNode = new GLabelNode(string);
        if (this.head == null) {
            this.head = this.tail = gLabelNode;
        } else {
            this.tail.setNext(gLabelNode);
            gLabelNode.setPrev(this.tail);
            this.tail = gLabelNode;
        }
        ++this.dim;
    }

    public void addToTail(String string, boolean bl) {
        GLabelNode gLabelNode = new GLabelNode(string, bl);
        if (this.head == null) {
            this.head = this.tail = gLabelNode;
        } else {
            this.tail.setNext(gLabelNode);
            gLabelNode.setPrev(this.tail);
            this.tail = gLabelNode;
        }
        ++this.dim;
    }

    public void flush() {
        this.tail = null;
        this.head = null;
        this.dim = 0;
    }

    public void mark(String string) {
        GLabelNode gLabelNode = this.head;
        while (gLabelNode != null) {
            if (string.equals(gLabelNode.getLabel())) {
                gLabelNode.setMarked(true);
                return;
            }
            gLabelNode = gLabelNode.getNext();
        }
    }

    public void unmarkAll() {
        GLabelNode gLabelNode = this.head;
        while (gLabelNode != null) {
            gLabelNode.setMarked(false);
            gLabelNode = gLabelNode.getNext();
        }
    }

    public String supplyLabel() {
        GLabelNode gLabelNode = this.head;
        while (gLabelNode != null) {
            if (!gLabelNode.isMarked()) {
                return gLabelNode.getLabel();
            }
            gLabelNode = gLabelNode.getNext();
        }
        return null;
    }

    public void supplyLabels(int n, GLabelList gLabelList) {
        GLabelNode gLabelNode = this.head;
        int n2 = 0;
        while (gLabelNode != null && n2 < n) {
            if (!gLabelNode.isMarked()) {
                gLabelList.addToTail(gLabelNode.getLabel());
                ++n2;
            }
            gLabelNode = gLabelNode.getNext();
        }
    }

    public GLabelNode getFirstUnmarked() {
        GLabelNode gLabelNode = this.head;
        while (gLabelNode != null) {
            if (!gLabelNode.isMarked()) {
                return gLabelNode;
            }
            gLabelNode = gLabelNode.getNext();
        }
        return null;
    }

    public GLabelList subtract(GVertexList gVertexList) {
        GLabelList gLabelList = new GLabelList();
        GLabelNode gLabelNode = this.head;
        while (gLabelNode != null) {
            String string = gLabelNode.getLabel();
            if (gVertexList.seek(string) == null) {
                gLabelList.addToTail(string);
            }
            gLabelNode = gLabelNode.getNext();
        }
        return gLabelList;
    }
}

