/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;

public class GEdgeList
implements Serializable {
    private GEdgeNode head;
    private GEdgeNode tail;
    private int dim = 0;

    public void print() {
        GEdgeNode gEdgeNode = this.head;
        while (gEdgeNode != null) {
            gEdgeNode.getEdge().print();
            gEdgeNode = gEdgeNode.getNext();
        }
    }

    public void setHead(GEdgeNode gEdgeNode) {
        this.head = gEdgeNode;
    }

    public void setHead(GEdge gEdge) {
        GEdgeNode gEdgeNode = this.head;
        while (true) {
            if (gEdgeNode.getEdge() == gEdge) {
                this.setHead(gEdgeNode);
                return;
            }
            gEdgeNode = gEdgeNode.getNext();
        }
    }

    public void addToHead(GEdge gEdge) {
        GEdgeNode gEdgeNode = new GEdgeNode(gEdge);
        if (this.head == null) {
            this.head = this.tail = gEdgeNode;
        } else {
            this.head.setPrev(gEdgeNode);
            gEdgeNode.setNext(this.head);
            this.head = gEdgeNode;
        }
        ++this.dim;
    }

    public void addToTail(GEdge gEdge) {
        GEdgeNode gEdgeNode = new GEdgeNode(gEdge);
        if (this.head == null) {
            this.head = this.tail = gEdgeNode;
        } else {
            this.tail.setNext(gEdgeNode);
            gEdgeNode.setPrev(this.tail);
            this.tail = gEdgeNode;
        }
        ++this.dim;
    }

    public GEdgeNode getHead() {
        return this.head;
    }

    public GEdgeNode getParaHead() {
        GEdgeNode gEdgeNode = this.head;
        while (gEdgeNode != null && gEdgeNode.getEdge().twin != null) {
            gEdgeNode = gEdgeNode.getNext();
        }
        if (gEdgeNode != null) {
            return gEdgeNode;
        }
        return null;
    }

    public GEdgeNode getTail() {
        return this.tail;
    }

    public int getDim() {
        return this.dim;
    }

    public void flush() {
        this.tail = null;
        this.head = null;
        this.dim = 0;
    }

    public GEdgeList toChain() {
        GEdgeList gEdgeList = new GEdgeList();
        GEdgeNode gEdgeNode = this.head;
        if (gEdgeNode == null) {
            return null;
        }
        do {
            gEdgeList.addToTail(gEdgeNode.getEdge());
        } while ((gEdgeNode = gEdgeNode.getNext()) != null && gEdgeNode.getEdge().getHead() == gEdgeNode.getPrev().getEdge().getTail());
        if (gEdgeList.getDim() == this.dim) {
            return this;
        }
        gEdgeNode = this.tail;
        do {
            gEdgeList.addToHead(gEdgeNode.getEdge());
        } while ((gEdgeNode = gEdgeNode.getPrev()) != null && gEdgeNode.getEdge().getTail() == gEdgeNode.getNext().getEdge().getHead());
        if (gEdgeList.dim < this.dim) {
            return null;
        }
        return gEdgeList;
    }

    public GEdgeList reverse() {
        GEdgeList gEdgeList = new GEdgeList();
        GEdgeNode gEdgeNode = this.head;
        while (gEdgeNode != null) {
            GEdge gEdge = gEdgeNode.getEdge();
            gEdgeList.addToHead(gEdge);
            gEdge.reverse();
            gEdgeNode = gEdgeNode.getNext();
        }
        return gEdgeList;
    }

    public GEdge seek(GEdge gEdge) {
        if (this.head == null) {
            return null;
        }
        GEdgeNode gEdgeNode = this.head;
        while (gEdgeNode != null) {
            GEdge gEdge2 = gEdgeNode.getEdge();
            if (gEdge2.getHead() == gEdge.getHead() && gEdge2.getTail() == gEdge.getTail() || gEdge2.getTail() == gEdge.getHead() && gEdge2.getHead() == gEdge.getTail()) {
                return gEdge2;
            }
            gEdgeNode = gEdgeNode.getNext();
        }
        return null;
    }

    public GEdge seek(String string, String string2) {
        if (this.head == null) {
            return null;
        }
        GEdgeNode gEdgeNode = this.head;
        while (gEdgeNode != null) {
            GEdge gEdge = gEdgeNode.getEdge();
            if (gEdge.vertexList.seek(string) != null && gEdge.vertexList.seek(string2) != null) {
                return gEdge;
            }
            gEdgeNode = gEdgeNode.getNext();
        }
        return null;
    }

    public GEdge seek(GVertex gVertex, GVertex gVertex2) {
        if (this.head == null) {
            return null;
        }
        GEdgeNode gEdgeNode = this.head;
        while (gEdgeNode != null) {
            GEdge gEdge = gEdgeNode.getEdge();
            if (gEdge.vertexList.seek(gVertex) != null && gEdge.vertexList.seek(gVertex2) != null) {
                return gEdge;
            }
            gEdgeNode = gEdgeNode.getNext();
        }
        return null;
    }

    public GEdge seek(GVertex gVertex) {
        if (this.head == null) {
            return null;
        }
        GEdgeNode gEdgeNode = this.head;
        while (gEdgeNode != null) {
            GEdge gEdge = gEdgeNode.getEdge();
            if (gEdge.vertexList.seek(gVertex) != null) {
                return gEdge;
            }
            gEdgeNode = gEdgeNode.getNext();
        }
        return null;
    }

    public void clearSelection() {
        if (this.dim == 0) {
            return;
        }
        GEdgeNode gEdgeNode = this.head;
        while (gEdgeNode != null) {
            gEdgeNode.getEdge().setSelected(false);
            gEdgeNode = gEdgeNode.getNext();
        }
    }

    public void remove(GEdge gEdge) {
        GEdgeNode gEdgeNode = this.head;
        while (gEdgeNode != null) {
            if (gEdgeNode.getEdge() == gEdge) {
                this.remove(gEdgeNode);
                return;
            }
            gEdgeNode = gEdgeNode.getNext();
        }
    }

    public void remove(GEdgeNode gEdgeNode) {
        GEdgeNode gEdgeNode2 = gEdgeNode.getPrev();
        GEdgeNode gEdgeNode3 = gEdgeNode.getNext();
        if (gEdgeNode2 == null && gEdgeNode3 == null) {
            this.head = null;
            this.tail = null;
        } else if (gEdgeNode2 == null) {
            gEdgeNode3.setPrev(null);
            this.head = gEdgeNode3;
        } else if (gEdgeNode3 == null) {
            gEdgeNode2.setNext(null);
            this.tail = gEdgeNode2;
        } else {
            gEdgeNode2.setNext(gEdgeNode3);
            gEdgeNode3.setPrev(gEdgeNode2);
        }
        --this.dim;
    }

    public GEdgeList renderToAngle() {
        if (this.dim < 2) {
            return null;
        }
        GEdgeList gEdgeList = new GEdgeList();
        GEdge gEdge = this.head.getEdge();
        GEdge gEdge2 = this.head.getNext().getEdge();
        GVertex gVertex = gEdge.getHead();
        GVertex gVertex2 = gEdge.getTail();
        GVertex gVertex3 = gEdge2.getHead();
        GVertex gVertex4 = gEdge2.getTail();
        if (gVertex == gVertex3) {
            gEdgeList.addToTail(gEdge);
            gEdgeList.addToTail(gEdge2);
            return gEdgeList;
        }
        if (gVertex == gVertex4) {
            gEdgeList.addToTail(gEdge);
            gEdgeList.addToTail(new GEdge(gVertex4, gVertex3, null));
            return gEdgeList;
        }
        if (gVertex2 == gVertex3) {
            gEdgeList.addToTail(new GEdge(gVertex2, gVertex, null));
            gEdgeList.addToTail(gEdge2);
            return gEdgeList;
        }
        if (gVertex2 == gVertex4) {
            gEdgeList.addToTail(new GEdge(gVertex2, gVertex, null));
            gEdgeList.addToTail(new GEdge(gVertex4, gVertex3, null));
            return gEdgeList;
        }
        return null;
    }

    public GEdgeList toCycle() {
        if (this.dim == 0) {
            return null;
        }
        GEdgeList gEdgeList = new GEdgeList();
        GEdgeNode gEdgeNode = this.head;
        while (gEdgeNode != null) {
            GEdge gEdge = gEdgeNode.getEdge();
            if (gEdge.twin == null) break;
            gEdgeList.addToTail(gEdge);
            gEdgeNode = gEdgeNode.getNext();
        }
        gEdgeList.getTail().setNext(gEdgeList.getHead());
        gEdgeList.getHead().setPrev(gEdgeList.getTail());
        return gEdgeList;
    }
}

