#if !defined(AFX_CALCDLG_H__DA8B4B10_D7C4_11D3_A23F_0020AFDC3196__INCLUDED_)
#define AFX_CALCDLG_H__DA8B4B10_D7C4_11D3_A23F_0020AFDC3196__INCLUDED_

#include <vector>
#include "CalcEdit.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// CalcDlg.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CCalcDlg dialog
class CMainFrame;

class CCalcDlg : public CDialog
{
    friend class CCalcEdit;
    friend class CHexEditApp;           // Allows macros to call protected members

    enum binop_type
    {
        binop_none = 0,

        binop_and,
        binop_or,
        binop_xor,

        // Arithmetic operators
        binop_add,
        binop_subtract,
        binop_multiply,

        binop_gtr = 90,                 // Leave the greater value
        binop_less,

        binop_mask = 100,               // Above this operands are masked to displayed bits

        binop_divide,
        binop_mod,
        binop_pow,                      // m^n

        // Moved gtr/less before binop_mask so that overflow test not done,
        // but left dummies here for macros recorded in version 1.1
        binop_gtr_old,                  
        binop_less_old,

        // Bit manipulation
        binop_rol,                      // Rotate 1st operand by number of bits in 2nd
        binop_ror,
        binop_lsl,                      // Shifts
        binop_lsr,
        binop_asr,

    };

    enum unary_type
    {
        unary_none = 0,

        // Arithmetic operators
        unary_inc,                      // Increment
        unary_dec,
        unary_sign,                     // Change sign

        // Bit manipulation
        unary_not,                      // Invert all bits
        unary_lsl,                      // Shifts

        unary_mask = 100,               // Above this the operand is masked to displayed bits

        unary_lsr,
        unary_asr,
        unary_rol,                      // Rotate one bit position
        unary_ror,
        unary_rev,                      // Reverse bit order

        unary_square,
        unary_squareroot,
        unary_cube,
        unary_factorial,

        // Others
        unary_flip,                     // Flip (reverse) byte order
        unary_at,                       // Get the value at the address
    };

// Construction
public:
	CCalcDlg(CWnd* pParent = NULL);   // standard constructor

    BOOL Create(CWnd* pParentWnd = NULL);   // Normal way to create the modeless dialog
    void Redisplay();
    void ShowStatus();
    void ShowBinop(int ii = -1);
    void FixFileButtons();
    void Set(unsigned __int64 v) { current_ = v; edit_.Put(); }
    void change_base(int);
    void change_bits(int);

// Dialog Data
	//{{AFX_DATA(CCalcDlg)
	enum { IDD = IDD_CALC };
	int		bits_index_;
	int		base_index_;
	BOOL	big_endian_;
	//}}AFX_DATA

    CCalcEdit edit_;                // Subclassed edit control

    BOOL visible_;                  // Is dialog visible? (We can do operations via macros even when not visible.)
    BOOL overflow_;                 // Has a numeric overflow occurred?
    BOOL error_;                    // Has a numeric error (eg. Div by 0) occurred?

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CCalcDlg)
	public:
	virtual BOOL Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext = NULL);
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CCalcDlg)
	afx_msg void OnDigit0();
	afx_msg void OnDigit1();
	afx_msg void OnDigit2();
	afx_msg void OnDigit3();
	afx_msg void OnDigit4();
	afx_msg void OnDigit5();
	afx_msg void OnDigit6();
	afx_msg void OnDigit7();
	afx_msg void OnDigit8();
	afx_msg void OnDigit9();
	afx_msg void OnDigitA();
	afx_msg void OnDigitB();
	afx_msg void OnDigitC();
	afx_msg void OnDigitD();
	afx_msg void OnDigitE();
	afx_msg void OnDigitF();
	afx_msg void OnBackspace();
	afx_msg void OnClearEntry();
	afx_msg void OnClear();
	afx_msg void OnEquals();
	afx_msg void OnAnd();
	afx_msg void OnAsr();
	afx_msg void OnDivide();
	afx_msg void OnLsl();
	afx_msg void OnLsr();
	afx_msg void OnRol();
	afx_msg void OnRor();
	afx_msg void OnXor();
	afx_msg void OnMod();
	afx_msg void OnMultiply();
	afx_msg void OnOr();
	afx_msg void OnUnaryDec();
	afx_msg void OnUnaryFactorial();
	afx_msg void OnUnaryFlip();
	afx_msg void OnUnaryRev();
	afx_msg void OnUnaryInc();
	afx_msg void OnUnaryNot();
	afx_msg void OnUnarySign();
	afx_msg void OnUnarySquare();
	afx_msg void OnSubtract();
	afx_msg void OnGo();
	afx_msg void OnMemGet();
	afx_msg void OnMemClear();
	afx_msg void OnMemAdd();
	afx_msg void OnMemSubtract();
	afx_msg void OnMarkGet();
	afx_msg void OnMarkAt();
	afx_msg void OnMarkAdd();
	afx_msg void OnMarkSubtract();
	afx_msg void OnSelGet();
	afx_msg void OnSelAt();
	afx_msg void OnEofGet();
	afx_msg void OnGtr();
	afx_msg void OnLess();
	afx_msg void OnPow();
	afx_msg void OnMarkAtStore();
	afx_msg void OnMarkClear();
	afx_msg void OnMarkStore();
	afx_msg void OnMemStore();
	afx_msg void OnSelAtStore();
	afx_msg void OnSelStore();
	afx_msg void OnUnaryRol();
	afx_msg void OnUnaryRor();
	afx_msg void OnUnaryLsl();
	afx_msg void OnUnaryLsr();
	afx_msg void OnUnaryAsr();
	afx_msg void OnUnaryCube();
	afx_msg void OnUnaryAt();
	afx_msg void OnUnarySquareRoot();
	afx_msg void OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct);
	virtual BOOL OnInitDialog();
	afx_msg void On8bit();
	afx_msg void On16bit();
	afx_msg void On32bit();
	afx_msg void On64bit();
	afx_msg void OnBinary();
	afx_msg void OnOctal();
	afx_msg void OnDecimal();
	afx_msg void OnHex();
	afx_msg void OnSelLen();
	afx_msg void OnSelLenStore();
	afx_msg void OnClose();
	afx_msg void OnAdd();
	afx_msg void OnDestroy();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	afx_msg void OnBigEndian();
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

    CToolTipCtrl ttc_;                      // For button tooltips

    void toggle_endian();
    void do_binop(binop_type binop);        // Handle binary operators
    void do_unary(unary_type unary);        // Handle unary operators
    void do_digit(char digit);              // Handle "digit" button on calculator
    void calc_previous();                   // Do binary operation using previous_ and current_

    CHexEditApp *aa_;                       // Ptr to the app (mainly for macro handling)
    CMainFrame *mm_;                        // Ptr to the main window

    CPen purple_pen;                        // Just to draw square root symbol

    // The following is used to keep track of where the current calculator contents came from.
    // That is, was the number typed in by the user or obtained using one of the buttons on
    // the left side of the calculator (memory recall etc).  This info is needed for later
    // playback of macros that use the calculator.  The value of source_ should be one of km_user,
    // km_memget, km_markget, km_markat, km_selget, km_selat, km_selend, km_sellen, km_eofget.

    km_type source_;                        // One of km_user to km_eofget, or km_result

    // The following is used to keep track of what binary operator is in use.  For example,
    // if the user does 123 + 456 then it has value km_add.  If no binary operation is currently
    // active then is has value km_unknown.
    binop_type op_;

    // xxx instead of the following perhaps we should just select all after "=" pressed
    // xxx eg. if !playback || update && visible
    BOOL in_edit_;                  // Can we edit the numbers in the edit box or should next edit clear it (eg. after "=" used)

    unsigned __int64 current_;      // Current value in the edit control (used by edit_)
    unsigned __int64 previous_;     // Previous value of edit control (if binary operator active)

    unsigned __int64 memory_;       // Current contents of memory (used with Memory, MS, MC, etc buttons)

    int radix_;                     // Actual radix (base) in use
    int bits_;                      // Numbers of bits in use: 8, 16, 32 or 64
    unsigned __int64 mask_;         // Mask for current value of bits_: 0xFF, 0xFFFF, 0xFFFFFFFF or 0xFFFFFFFFFFFFFFFF
    unsigned __int64 sign_mask_;    // Mask to check sign bit of bits_: 0x80, 0x8000, 0x80000000 or 0x8000000000000000
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CALCDLG_H__DA8B4B10_D7C4_11D3_A23F_0020AFDC3196__INCLUDED_)
