<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <!-- f2xml custom transformation.                                   -->

  <!-- Email  : help@boulderwall.com                                  -->
  <!-- Web    : http://www.boulderwall.com                            -->
  <!-- Name   : top10.xsl                                             -->
  <!-- Purpose: Transform XML filelist into an HTML listing showing   -->
  <!--          the 'n' largest files and 'n' largest folders.        -->
  <!--          'n' is 10 by defalut.                                 -->

  <xsl:variable name="n" select="'10'"/>

  <xsl:output method="html"/>

  <xsl:template match="/">
    <xsl:comment>
    Created by top10.xsl. Input XML created by f2xml from www.boulderwall.com 
    </xsl:comment>
    <html>
      <body>
        <center>
          <h2>Top <xsl:value-of select="$n"/> largest files and folders<br/>
            <font color="blue">
              <xsl:value-of select="filetree/folder/@name"/>
            </font>
          </h2>
          <h4>created by f2xml via top10.xsl<br/>
            <font size="-1">
              <a href="http://www.boulderwall.com">www.boulderwall.com</a>
            </font>
          </h4>
        </center>

        <xsl:if test="//file[@name='BOULDERWALL.com']">
          <h4>NOTE: XML output is from an unlicensed version of f2xml. Some files may be missing or named BOULDERWALL.com</h4>
        </xsl:if>

        <h4>Largest files</h4>
        <ol>
          <xsl:for-each select="//file">
            <xsl:sort select="size" data-type="number" order="descending"/>
            <xsl:if test="position()&lt;($n + 1)">
              <li>
                <b><xsl:value-of select="@name"/></b>
                <xsl:text> </xsl:text>
                <xsl:value-of select="size"/>
                <xsl:text> bytes </xsl:text>
                <xsl:value-of select="fullpath"/>
              </li>
            </xsl:if>
          </xsl:for-each>
        </ol>
        <h4>Largest folders</h4>
        <ol>
          <xsl:for-each select="//folder">
            <xsl:sort select="size" data-type="number" order="descending"/>
            <xsl:if test="position()&lt;($n + 1)">
              <li>
                <b><xsl:value-of select="@name"/></b>
                <xsl:text> </xsl:text>
                <xsl:value-of select="size"/>
                <xsl:text> bytes </xsl:text>
                <xsl:value-of select="fullpath"/>
              </li>
            </xsl:if>
          </xsl:for-each>
        </ol>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="text()"/>

</xsl:stylesheet>
